/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.user;

import gg.auroramc.aurora.api.user.UserDataHolder;
import gg.auroramc.aurora.api.util.NamespacedId;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Nullable;

public class UserMetaHolder
extends UserDataHolder {
    private final Map<String, Object> meta = new ConcurrentHashMap<String, Object>();

    @Override
    public NamespacedId getId() {
        return NamespacedId.fromDefault("meta");
    }

    @Override
    public void serializeInto(ConfigurationSection data) {
        for (String string : data.getKeys(false)) {
            data.set(string, null);
        }
        for (Map.Entry entry : this.meta.entrySet()) {
            data.set((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void initFrom(@Nullable ConfigurationSection data) {
        if (data == null) {
            return;
        }
        for (String key : data.getKeys(false)) {
            this.meta.put(key, data.get(key));
        }
    }

    public Object getMeta(String key) {
        return this.meta.get(key);
    }

    public Double getMeta(String key, double def) {
        Object m = this.meta.get(key);
        return m == null ? def : (Double)m;
    }

    public String getMeta(String key, String def) {
        Object m = this.meta.get(key);
        return m == null ? def : m.toString();
    }

    public boolean setMeta(String key, double value) {
        if (!this.getUser().isLoaded()) {
            return false;
        }
        this.meta.put(key, value);
        this.dirty.set(true);
        return true;
    }

    public boolean setMeta(String key, String value) {
        if (!this.getUser().isLoaded()) {
            return false;
        }
        this.meta.put(key, value);
        this.dirty.set(true);
        return true;
    }

    public boolean removeMeta(String key) {
        if (!this.getUser().isLoaded()) {
            return false;
        }
        this.meta.remove(key);
        this.dirty.set(true);
        return true;
    }

    public boolean incrementMeta(String key, Double value) {
        if (!this.getUser().isLoaded()) {
            return false;
        }
        this.meta.put(key, this.getMeta(key, 0.0) + value);
        this.dirty.set(true);
        return true;
    }

    public boolean decrementMeta(String key, Double value) {
        return this.decrementMeta(key, value, false);
    }

    public boolean decrementMeta(String key, Double value, boolean allowNegative) {
        if (!this.getUser().isLoaded()) {
            return false;
        }
        if (allowNegative) {
            this.meta.put(key, this.getMeta(key, 0.0) - value);
        } else {
            double newValue = this.getMeta(key, 0.0) - value;
            if (newValue < 0.0) {
                newValue = 0.0;
            }
            this.meta.put(key, newValue);
        }
        this.dirty.set(true);
        return true;
    }

    public List<String> getMetaKeys() {
        return List.copyOf(this.meta.keySet());
    }
}

