/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.user.storage;

import com.google.common.util.concurrent.AtomicDouble;

public class LatencyMeasure {
    private final AtomicDouble count = new AtomicDouble(0.0);
    private final AtomicDouble total = new AtomicDouble(0.0);

    public void addLatency(double latency) {
        this.count.addAndGet(1.0);
        this.total.addAndGet(latency);
    }

    public double getAverageLatency() {
        return this.total.get() / Math.max(1.0, this.count.get());
    }

    public String prettyPrint() {
        return String.format("%.2f ms", this.getAverageLatency() / 1000000.0);
    }
}

