/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.user.storage;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.user.AuroraUser;
import gg.auroramc.aurora.api.user.UserDataHolder;
import gg.auroramc.aurora.api.user.storage.SaveReason;
import gg.auroramc.aurora.api.user.storage.UserStorage;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlStorage
implements UserStorage {
    public DirectoryStream<Path> getFileStream() throws IOException {
        File file = new File(String.valueOf(Aurora.getInstance().getDataFolder()) + "/userdata");
        return Files.newDirectoryStream(file.toPath(), "*.yml");
    }

    @Override
    public void loadUser(UUID uuid, Set<Class<? extends UserDataHolder>> dataHolders, Consumer<AuroraUser> handler) {
        long start = System.nanoTime();
        File file = new File(String.valueOf(Aurora.getInstance().getDataFolder()) + "/userdata", String.valueOf(uuid) + ".yml");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                Aurora.logger().severe("Failed to create data file for player: " + String.valueOf(uuid));
            }
        }
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)file);
        AuroraUser user = new AuroraUser(uuid);
        user.initData(data, dataHolders);
        long end = System.nanoTime();
        Aurora.getUserManager().getLoadLatencyMeasure().addLatency(end - start);
        handler.accept(user);
    }

    @Override
    public AuroraUser loadUser(UUID uuid, Set<Class<? extends UserDataHolder>> dataHolders) {
        File file = new File(String.valueOf(Aurora.getInstance().getDataFolder()) + "/userdata", String.valueOf(uuid) + ".yml");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                Aurora.logger().severe("Failed to create data file for player: " + String.valueOf(uuid));
            }
        }
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)file);
        AuroraUser user = new AuroraUser(uuid);
        user.initData(data, dataHolders);
        return user;
    }

    @Override
    public synchronized boolean saveUser(AuroraUser user, SaveReason reason) {
        File file = new File(String.valueOf(Aurora.getInstance().getDataFolder()) + "/userdata", String.valueOf(user.getUniqueId()) + ".yml");
        try {
            long start = System.nanoTime();
            user.serializeData().save(file);
            long end = System.nanoTime();
            Aurora.getUserManager().getSaveLatencyMeasure().addLatency(end - start);
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    @Override
    public int bulkSaveUsers(List<AuroraUser> users, SaveReason reason) {
        int saved = 0;
        for (AuroraUser user : users) {
            boolean success = this.saveUser(user, reason);
            if (!success) continue;
            ++saved;
        }
        return saved;
    }

    @Override
    public void purgeUser(UUID uuid) {
        File file = new File(String.valueOf(Aurora.getInstance().getDataFolder()) + "/userdata", String.valueOf(uuid) + ".yml");
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public void dispose() {
    }
}

