/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.user.storage.sql;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.user.AuroraUser;
import gg.auroramc.aurora.api.user.UserDataHolder;
import gg.auroramc.aurora.api.user.storage.SaveReason;
import gg.auroramc.aurora.api.user.storage.UserStorage;
import gg.auroramc.aurora.api.user.storage.sql.DatabaseCredentials;
import gg.auroramc.aurora.expansions.leaderboard.model.LbEntry;
import gg.auroramc.aurora.expansions.leaderboard.storage.BoardValue;
import gg.auroramc.aurora.expansions.leaderboard.storage.LeaderboardStorage;
import gg.auroramc.aurora.libs.hikari.HikariConfig;
import gg.auroramc.aurora.libs.hikari.HikariDataSource;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class MySqlStorage
implements UserStorage,
LeaderboardStorage {
    private final HikariDataSource dataSource;
    private final DatabaseCredentials credentials;
    private final String tableName = "aurora_user_data";
    private final String syncTableName = "aurora_sync";
    private final String leaderboardTableName = "aurora_leaderboard";
    private final int networkLatency;
    private final int syncRetryCount;

    public MySqlStorage() {
        int poolSize = Aurora.getInstance().getConfig().getInt("mysql.pool-size", 10);
        this.networkLatency = Aurora.getInstance().getConfig().getInt("mysql.network-latency", 500);
        this.syncRetryCount = Aurora.getInstance().getConfig().getInt("mysql.sync-retry-count", 3);
        this.credentials = this.readCredentials();
        HikariConfig config = new HikariConfig();
        config.setPoolName("aurora-pool");
        config.setConnectionTimeout(5000L);
        config.setJdbcUrl("jdbc:mysql://" + this.credentials.host() + ":" + this.credentials.port() + "/" + this.credentials.database() + "?useSSL=" + this.credentials.ssl());
        config.setUsername(this.credentials.username());
        config.setPassword(this.credentials.password());
        config.setMaximumPoolSize(poolSize);
        this.dataSource = new HikariDataSource(config);
        this.createTable();
    }

    public Set<String> getUserIds(int limit, int offset) {
        HashSet<String> ids = new HashSet<String>();
        String query = "SELECT DISTINCT player_uuid FROM aurora_user_data ORDER BY id LIMIT ? OFFSET ?";
        try (Connection conn = this.connection();
             PreparedStatement ps = conn.prepareStatement(query);){
            ps.setInt(1, limit);
            ps.setInt(2, offset);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ids.add(rs.getString("player_uuid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return ids;
    }

    @Override
    public void loadUser(UUID uuid, Set<Class<? extends UserDataHolder>> dataHolders, Consumer<AuroraUser> handler) {
        this.loadUser(uuid, dataHolders, this.syncRetryCount, handler);
    }

    @Override
    public AuroraUser loadUser(UUID uuid, Set<Class<? extends UserDataHolder>> dataHolders) {
        AuroraUser auroraUser;
        block8: {
            Connection connection = this.connection();
            try {
                auroraUser = this.loadUserForReal(connection, uuid, dataHolders);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return this.createEmptyUser(uuid, dataHolders, false);
                }
            }
            connection.close();
        }
        return auroraUser;
    }

    public void loadUser(UUID uuid, Set<Class<? extends UserDataHolder>> dataHolders, int count, Consumer<AuroraUser> handler) {
        Bukkit.getAsyncScheduler().runDelayed((Plugin)Aurora.getInstance(), task -> {
            try (Connection connection = this.connection();){
                AuroraUser user;
                if (Bukkit.getPlayer((UUID)uuid) == null) {
                    Aurora.logger().debug("Player: " + String.valueOf(uuid) + " is left, aborting load.");
                    return;
                }
                if (count <= 0) {
                    Aurora.logger().debug("We are still in sync lock after " + this.syncRetryCount + " retry for player: " + String.valueOf(uuid) + ". We won't wait anymore. Loading form database...");
                    user = this.loadUserForReal(connection, uuid, dataHolders);
                    if (user == null) {
                        return;
                    }
                    handler.accept(user);
                    this.createSyncFlag(uuid, connection);
                    Aurora.logger().debug("Player: " + String.valueOf(uuid) + " loaded from database.");
                    return;
                }
                if (!this.isLocked(uuid, connection)) {
                    user = this.loadUserForReal(connection, uuid, dataHolders);
                    if (user == null) {
                        return;
                    }
                    handler.accept(user);
                    this.createSyncFlag(uuid, connection);
                    Aurora.logger().debug("Player: " + String.valueOf(uuid) + " loaded from database.");
                } else {
                    Aurora.logger().debug("Sync lock detected for player: " + String.valueOf(uuid) + ", retrying...");
                    this.loadUser(uuid, dataHolders, count - 1, handler);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, (long)this.networkLatency, TimeUnit.MILLISECONDS);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public AuroraUser loadUserForReal(Connection connection, UUID uuid, Set<Class<? extends UserDataHolder>> dataHolders) {
        String loadQuery = "SELECT * FROM aurora_user_data WHERE player_uuid=?;";
        long start = System.nanoTime();
        try (PreparedStatement statement = connection.prepareStatement(loadQuery);){
            AuroraUser auroraUser;
            block19: {
                ResultSet resultSet;
                block17: {
                    AuroraUser auroraUser2;
                    block18: {
                        statement.setString(1, uuid.toString());
                        resultSet = statement.executeQuery();
                        if (resultSet.next()) break block17;
                        auroraUser2 = this.createEmptyUser(uuid, dataHolders, true);
                        if (resultSet == null) break block18;
                        resultSet.close();
                    }
                    return auroraUser2;
                }
                try {
                    AuroraUser user = new AuroraUser(uuid);
                    YamlConfiguration config = new YamlConfiguration();
                    do {
                        String holder = resultSet.getString("holder");
                        String rawYaml = resultSet.getString("data");
                        YamlConfiguration section = new YamlConfiguration();
                        section.loadFromString(rawYaml);
                        config.set(holder, (Object)section);
                    } while (resultSet.next());
                    user.initData(config, dataHolders);
                    long end = System.nanoTime();
                    Aurora.getUserManager().getLoadLatencyMeasure().addLatency(end - start);
                    auroraUser = user;
                    if (resultSet == null) break block19;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return auroraUser;
        }
        catch (Exception e) {
            Aurora.logger().severe("Failed to load user data for player: " + String.valueOf(uuid));
            return this.createEmptyUser(uuid, dataHolders, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveUser(AuroraUser user, SaveReason reason) {
        UUID uuid = user.getUniqueId();
        String saveQuery = "INSERT INTO aurora_user_data (player_uuid, holder, data) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE data=?;";
        Object object = user.getSerializeLock();
        synchronized (object) {
            boolean bl;
            block21: {
                long start = System.nanoTime();
                Connection connection = this.connection();
                try {
                    connection.setAutoCommit(false);
                    try (PreparedStatement statement = connection.prepareStatement(saveQuery);){
                        for (UserDataHolder holder : user.getDataHolders().stream().filter(UserDataHolder::isDirty).toList()) {
                            YamlConfiguration data = new YamlConfiguration();
                            holder.serializeInto((ConfigurationSection)data);
                            String serializedData = data.saveToString();
                            statement.setString(1, uuid.toString());
                            statement.setString(2, holder.getId().toString());
                            statement.setString(3, serializedData);
                            statement.setString(4, serializedData);
                            statement.addBatch();
                        }
                        statement.executeBatch();
                    }
                    long end = System.nanoTime();
                    Aurora.getUserManager().getSaveLatencyMeasure().addLatency(end - start);
                    if (reason == SaveReason.QUIT) {
                        this.removeSyncFlag(uuid, connection);
                    }
                    connection.commit();
                    bl = true;
                    if (connection == null) break block21;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        Aurora.logger().severe("Failed to save user data for player: " + String.valueOf(uuid));
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int bulkSaveUsers(List<AuroraUser> users, SaveReason reason) {
        int n;
        block30: {
            String saveQuery = "INSERT INTO aurora_user_data (player_uuid, holder, data) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE data=?;";
            Connection connection = this.connection();
            try {
                connection.setAutoCommit(false);
                int BATCH_SIZE = 100;
                int batchCount = 0;
                try (PreparedStatement statement = connection.prepareStatement(saveQuery);){
                    for (AuroraUser user : users) {
                        UUID uuid = user.getUniqueId();
                        Object object = user.getSerializeLock();
                        synchronized (object) {
                            for (UserDataHolder holder : user.getDataHolders().stream().filter(UserDataHolder::isDirty).toList()) {
                                YamlConfiguration data = new YamlConfiguration();
                                holder.serializeInto((ConfigurationSection)data);
                                String serializedData = data.saveToString();
                                statement.setString(1, uuid.toString());
                                statement.setString(2, holder.getId().toString());
                                statement.setString(3, serializedData);
                                statement.setString(4, serializedData);
                                statement.addBatch();
                                if (++batchCount < 100) continue;
                                statement.executeBatch();
                                statement.clearBatch();
                                batchCount = 0;
                            }
                        }
                    }
                    if (batchCount > 0) {
                        statement.executeBatch();
                    }
                }
                if (reason == SaveReason.QUIT) {
                    String deleteQuery = "DELETE FROM aurora_sync WHERE player_uuid=? OR created < NOW() - INTERVAL 2 DAY;";
                    try (PreparedStatement statement = connection.prepareStatement(deleteQuery);){
                        for (AuroraUser user : users) {
                            statement.setString(1, user.getUniqueId().toString());
                            statement.addBatch();
                        }
                        statement.executeBatch();
                    }
                }
                connection.commit();
                n = users.size();
                if (connection == null) break block30;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Aurora.logger().severe("Failed to save user data for players.");
                    e.printStackTrace();
                    return 0;
                }
            }
            connection.close();
        }
        return n;
    }

    @Override
    public void purgeUser(UUID uuid) {
        String deleteStmt = "DELETE FROM aurora_user_data WHERE player_uuid=?;";
        try (Connection connection = this.connection();
             PreparedStatement statement = connection.prepareStatement(deleteStmt);){
            statement.setString(1, uuid.toString());
            statement.executeUpdate();
        }
        catch (Exception e) {
            Aurora.logger().severe("Failed to purge user data for player: " + String.valueOf(uuid));
        }
    }

    private void createSyncFlag(UUID uuid, Connection connection) {
        String insertQuery = "INSERT INTO aurora_sync (player_uuid) VALUES (?) ON DUPLICATE KEY UPDATE created=NOW();";
        try {
            long start = System.nanoTime();
            try (PreparedStatement statement = connection.prepareStatement(insertQuery);){
                statement.setString(1, uuid.toString());
                statement.executeUpdate();
            }
            long end = System.nanoTime();
            Aurora.getUserManager().getSyncFlagLatencyMeasure().addLatency(end - start);
        }
        catch (SQLException e) {
            Aurora.logger().warning("Failed to add sync flag for player: " + String.valueOf(uuid));
        }
    }

    private void removeSyncFlag(UUID uuid, Connection connection) {
        String deleteQuery = "DELETE FROM aurora_sync WHERE player_uuid=? OR created < NOW() - INTERVAL 2 DAY;";
        try (PreparedStatement statement = connection.prepareStatement(deleteQuery);){
            statement.setString(1, uuid.toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            Aurora.logger().warning("Failed to remove sync flag for player: " + String.valueOf(uuid));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isLocked(UUID uuid, Connection connection) {
        String query = "SELECT * FROM aurora_sync WHERE player_uuid=? AND created > NOW() - INTERVAL 2 DAY;";
        try (PreparedStatement statement = connection.prepareStatement(query);){
            boolean bl;
            block14: {
                statement.setString(1, uuid.toString());
                ResultSet resultSet = statement.executeQuery();
                try {
                    bl = resultSet.next();
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
        catch (SQLException e) {
            Aurora.logger().warning("Error checking sync lock status for player: " + String.valueOf(uuid));
            return false;
        }
    }

    private DatabaseCredentials readCredentials() {
        FileConfiguration config = Aurora.getInstance().getConfig();
        return new DatabaseCredentials(config.getString("mysql.host", "127.0.0.1"), config.getInt("mysql.port", 3306), config.getString("mysql.database", "AuroraCore"), config.getString("mysql.username"), config.getString("mysql.password"), config.getBoolean("mysql.ssl", false));
    }

    private Connection connection() throws SQLException {
        return this.dataSource.getConnection();
    }

    private void createTable() throws SQLException {
        try (Connection connection = this.connection();
             Statement statement = connection.createStatement(1003, 1007);){
            for (String schema : this.getTableSchema()) {
                statement.execute(schema);
            }
        }
    }

    private AuroraUser createEmptyUser(UUID uuid, Set<Class<? extends UserDataHolder>> dataHolders, boolean markAsLoaded) {
        AuroraUser user = new AuroraUser(uuid, markAsLoaded);
        user.initData(null, dataHolders);
        return user;
    }

    private String[] getTableSchema() {
        return new String(Aurora.getInstance().getResource("database/schema.sql").readAllBytes(), StandardCharsets.UTF_8).replaceAll("%user_table%", "aurora_user_data").replaceAll("%sync_table%", "aurora_sync").replaceAll("%leaderboard_table%", "aurora_leaderboard").split(";");
    }

    @Override
    public List<LbEntry> getTopEntries(String board, int limit) {
        ArrayList<LbEntry> entries = new ArrayList<LbEntry>();
        String query = "SELECT player_uuid, name, board, value, RANK() OVER (ORDER BY value DESC) as position FROM aurora_leaderboard WHERE board = ? ORDER BY value DESC LIMIT ?";
        try (Connection conn = this.connection();
             PreparedStatement ps = conn.prepareStatement(query);){
            ps.setString(1, board);
            ps.setInt(2, limit);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                UUID uuid = UUID.fromString(rs.getString("player_uuid"));
                String name = rs.getString("name");
                String boardName = rs.getString("board");
                double value = rs.getDouble("value");
                long position = rs.getLong("position");
                entries.add(new LbEntry(uuid, name, boardName, value, position));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return entries;
    }

    @Override
    public Map<String, LbEntry> getPlayerEntries(UUID uuid) {
        HashMap<String, LbEntry> entries = new HashMap<String, LbEntry>();
        String query = "    WITH RankedEntries AS (\n        SELECT\n            player_uuid,\n            name,\n            board,\n            value,\n            RANK() OVER (PARTITION BY board ORDER BY value DESC) as position\n        FROM aurora_leaderboard\n    )\n    SELECT player_uuid, name, board, value, position\n    FROM RankedEntries\n    WHERE player_uuid = ?\n";
        try (Connection conn = this.connection();
             PreparedStatement ps = conn.prepareStatement(query);){
            ps.setString(1, uuid.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String boardName = rs.getString("board");
                String name = rs.getString("name");
                double value = rs.getDouble("value");
                long position = rs.getLong("position");
                entries.put(boardName, new LbEntry(uuid, name, boardName, value, position));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return entries;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getTotalEntryCount(String board) {
        String query = "SELECT COUNT(*) as total FROM aurora_leaderboard WHERE board = ?";
        try (Connection conn = this.connection();
             PreparedStatement ps = conn.prepareStatement(query);){
            ps.setString(1, board);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return 0L;
            long l = rs.getLong("total");
            return l;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    @Override
    public void clearBoard(String board) {
        String query = "DELETE FROM aurora_leaderboard WHERE board = ?";
        try (Connection conn = this.connection();
             PreparedStatement ps = conn.prepareStatement(query);){
            ps.setString(1, board);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateEntry(UUID uuid, Set<BoardValue> values) {
        String query = "INSERT INTO aurora_leaderboard (player_uuid, name, board, value) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE value = ?, name = ?";
        try (Connection conn = this.connection();
             PreparedStatement ps = conn.prepareStatement(query);){
            String name = Bukkit.getOfflinePlayer((UUID)uuid).getName();
            for (BoardValue boardValue : values) {
                ps.setString(1, uuid.toString());
                ps.setString(2, name);
                ps.setString(3, boardValue.board());
                ps.setDouble(4, boardValue.value());
                ps.setDouble(5, boardValue.value());
                ps.setString(6, name);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void bulkUpdateEntries(Map<UUID, Set<BoardValue>> values) {
        String query = "INSERT INTO aurora_leaderboard (player_uuid, name, board, value) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE value = ?, name = ?";
        int BATCH_SIZE = 100;
        int batchCount = 0;
        try (Connection conn = this.connection();
             PreparedStatement ps = conn.prepareStatement(query);){
            for (Map.Entry<UUID, Set<BoardValue>> entry : values.entrySet()) {
                UUID uuid = entry.getKey();
                String name = Bukkit.getOfflinePlayer((UUID)uuid).getName();
                for (BoardValue boardValue : entry.getValue()) {
                    ps.setString(1, uuid.toString());
                    ps.setString(2, name);
                    ps.setString(3, boardValue.board());
                    ps.setDouble(4, boardValue.value());
                    ps.setDouble(5, boardValue.value());
                    ps.setString(6, name);
                    ps.addBatch();
                    if (++batchCount < 100) continue;
                    ps.executeBatch();
                    ps.clearBatch();
                    batchCount = 0;
                }
            }
            if (batchCount > 0) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dispose() {
        if (this.dataSource.isClosed()) {
            return;
        }
        this.dataSource.close();
    }
}

