/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.Collection;
import org.bukkit.inventory.ItemStack;

public class InventorySerializer {
    public static byte[] serializeItemsAsBytes(Collection<ItemStack> items) {
        Object object;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            DataOutputStream output = new DataOutputStream(outputStream);
            output.writeInt(items.size());
            for (ItemStack item : items) {
                if (item == null || item.isEmpty()) {
                    output.writeInt(0);
                    continue;
                }
                byte[] itemBytes = item.serializeAsBytes();
                output.writeInt(itemBytes.length);
                output.write(itemBytes);
            }
            object = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error while writing itemstack", e);
            }
        }
        outputStream.close();
        return object;
    }

    public static String serializeItemsAsBase64(Collection<ItemStack> items) {
        return Base64.getEncoder().encodeToString(InventorySerializer.serializeItemsAsBytes(items));
    }

    public static ItemStack[] deserializeItemsFromBase64(String base64) {
        return InventorySerializer.deserializeItemsFromBytes(Base64.getDecoder().decode(base64));
    }

    public static ItemStack readItemStackFromBase64(String base64) {
        return ItemStack.deserializeBytes((byte[])Base64.getDecoder().decode(base64));
    }

    public static String writeItemStackToBase64(ItemStack item) {
        return Base64.getEncoder().encodeToString(item.serializeAsBytes());
    }

    public static ItemStack[] deserializeItemsFromBytes(byte[] bytes) {
        ItemStack[] itemStackArray;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            DataInputStream input = new DataInputStream(inputStream);
            int count = input.readInt();
            ItemStack[] items = new ItemStack[count];
            for (int i = 0; i < count; ++i) {
                int length = input.readInt();
                if (length == 0) {
                    items[i] = ItemStack.empty();
                    continue;
                }
                byte[] itemBytes = new byte[length];
                input.read(itemBytes);
                items[i] = ItemStack.deserializeBytes((byte[])itemBytes);
            }
            itemStackArray = items;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error while reading itemstack", e);
            }
        }
        inputStream.close();
        return itemStackArray;
    }
}

