/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.api.util;

import gg.auroramc.aurora.Aurora;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class Version {
    public static final int MAJOR_VERSION = Version.getMajorVersion(Version.getVersionString(Bukkit.getBukkitVersion()));
    public static final int MINOR_VERSION = Version.getMinorVersion(Version.getVersionString(Bukkit.getBukkitVersion()));
    private static boolean IS_FOLIA = Version.getFolia();

    public static boolean isPigman(EntityType type) {
        if (MAJOR_VERSION == 16) {
            return type.equals((Object)EntityType.ZOMBIFIED_PIGLIN);
        }
        return type.name().equals("PIG_ZOMBIE");
    }

    private static boolean getFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            Aurora.logger().debug("Detected Folia.");
            return true;
        }
        catch (ClassNotFoundException e) {
            Aurora.logger().debug("We are not running on Folia.");
            return false;
        }
    }

    public static boolean isFolia() {
        return IS_FOLIA;
    }

    public static boolean isAtLeastVersion(int version) {
        return MAJOR_VERSION >= version;
    }

    public static boolean isAtLeastVersion(int majorVersionReq, int minorVersionReq) {
        if (MAJOR_VERSION > majorVersionReq) {
            return true;
        }
        if (MAJOR_VERSION == majorVersionReq) {
            return MINOR_VERSION >= minorVersionReq;
        }
        return false;
    }

    public static int getMinorVersion(String version) {
        if (version != null) {
            int lastDot = version.lastIndexOf(46);
            if (version.indexOf(46) != lastDot) {
                return Integer.parseInt(version.substring(lastDot + 1));
            }
            return 0;
        }
        throw new IllegalArgumentException("Failed to parse minor version from version string");
    }

    public static int getMajorVersion(String version) {
        if (version != null) {
            int lastDot = version.lastIndexOf(".");
            int firstDot = version.indexOf(".");
            if (firstDot != lastDot) {
                return Integer.parseInt(version.substring(firstDot + 1, lastDot));
            }
            return Integer.parseInt(version.substring(firstDot + 1));
        }
        throw new IllegalArgumentException("Failed to parse major version from version string");
    }

    public static String getVersionString(@Nullable String version) {
        if (version == null || version.isEmpty()) {
            return null;
        }
        int index = version.lastIndexOf("MC:");
        if (index != -1) {
            version = version.substring(index + 4, version.length() - 1);
        } else if (version.endsWith("SNAPSHOT")) {
            index = version.indexOf(45);
            version = version.substring(0, index);
        }
        version = version.split(" ")[0];
        return version;
    }
}

