/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.commands;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.command.ArgumentParser;
import gg.auroramc.aurora.api.command.CommandDispatcher;
import gg.auroramc.aurora.api.item.TypeId;
import gg.auroramc.aurora.api.message.Chat;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.user.AuroraUser;
import gg.auroramc.aurora.api.util.ItemUtils;
import gg.auroramc.aurora.config.MessageConfig;
import gg.auroramc.aurora.expansions.gui.GuiExpansion;
import gg.auroramc.aurora.expansions.item.ItemExpansion;
import gg.auroramc.aurora.expansions.leaderboard.LeaderboardExpansion;
import gg.auroramc.aurora.expansions.region.RegionExpansion;
import gg.auroramc.aurora.libs.acf.BaseCommand;
import gg.auroramc.aurora.libs.acf.annotation.CommandAlias;
import gg.auroramc.aurora.libs.acf.annotation.CommandCompletion;
import gg.auroramc.aurora.libs.acf.annotation.CommandPermission;
import gg.auroramc.aurora.libs.acf.annotation.Default;
import gg.auroramc.aurora.libs.acf.annotation.Flags;
import gg.auroramc.aurora.libs.acf.annotation.Subcommand;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

@CommandAlias(value="aurora")
public class AuroraCommand
extends BaseCommand {
    private final Aurora plugin;

    public AuroraCommand(Aurora plugin) {
        this.plugin = plugin;
    }

    @Subcommand(value="reload")
    @CommandPermission(value="aurora.core.admin.reload")
    public void onReload(CommandSender sender) {
        this.plugin.reload();
        MessageConfig messages = Aurora.getMsg(sender);
        Chat.sendMessage(sender, messages.getReloaded(), new Placeholder[0]);
    }

    @Subcommand(value="debug blockinfo")
    @CommandPermission(value="aurora.core.admin.debug.blockinfo")
    public void onBlockInfo(Player player) {
        RegionExpansion regionExpansion = Aurora.getExpansionManager().getExpansion(RegionExpansion.class);
        Block block = player.getTargetBlockExact(25);
        if (block == null) {
            return;
        }
        if (!regionExpansion.isPlacedBlock(block)) {
            Chat.sendMessage(player, "&cBlock is not placed by a player.", new Placeholder[0]);
            return;
        }
        Chat.sendMessage(player, "&eBlock placed by a player", new Placeholder[0]);
    }

    @Subcommand(value="debug latency")
    @CommandPermission(value="aurora.core.admin.debug.latency")
    public void onLatencyInfo(CommandSender sender) {
        Chat.sendMessage(sender, "Save: " + Aurora.getUserManager().getSaveLatencyMeasure().prettyPrint(), new Placeholder[0]);
        Chat.sendMessage(sender, "Load: " + Aurora.getUserManager().getLoadLatencyMeasure().prettyPrint(), new Placeholder[0]);
        Chat.sendMessage(sender, "Sync flag create: " + Aurora.getUserManager().getSyncFlagLatencyMeasure().prettyPrint(), new Placeholder[0]);
    }

    @Subcommand(value="debug blockremove")
    @CommandPermission(value="aurora.core.admin.debug.blockremove")
    public void onBlockRemove(Player player) {
        RegionExpansion regionExpansion = Aurora.getExpansionManager().getExpansion(RegionExpansion.class);
        Block block = player.getTargetBlockExact(25);
        if (block == null) {
            return;
        }
        if (!regionExpansion.isPlacedBlock(block)) {
            Chat.sendMessage(player, "&cBlock is not placed by a player.", new Placeholder[0]);
            return;
        }
        regionExpansion.removePlacedBlock(block);
        Chat.sendMessage(player, "&eBlock is now not registered as player placed.", new Placeholder[0]);
    }

    @Subcommand(value="debug itemid")
    @CommandPermission(value="aurora.core.admin.debug.itemid")
    public void onItemId(Player player) {
        TypeId id = AuroraAPI.getItemManager().resolveId(player.getInventory().getItemInMainHand());
        Chat.sendMessage(player, "&aItem id: " + id.toString(), new Placeholder[0]);
    }

    @Subcommand(value="dispatch")
    @CommandCompletion(value="@players @commandActions @nothing")
    @CommandPermission(value="aurora.core.admin.dispatch")
    public void onDispatch(CommandSender sender, @Flags(value="other") Player player, String action, String ... args) {
        String command = String.join((CharSequence)" ", args);
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        CommandDispatcher.dispatch(player, action + " " + command);
    }

    @Subcommand(value="dbmigrate")
    @CommandCompletion(value="@range:1-16")
    @CommandPermission(value="aurora.core.admin.dbmigrate")
    public void onDBMigrate(CommandSender sender, @Default(value="5") Integer threadCount) {
        MessageConfig messages = Aurora.getMsg(sender);
        Chat.sendMessage(sender, messages.getDbMigrateStarted(), new Placeholder[0]);
        Aurora.getUserManager().attemptMigration(threadCount).thenAccept(success -> {
            Player player;
            String msg;
            String string = msg = success != false ? messages.getDbMigrateFinished() : messages.getDbMigrateFailed();
            if (sender instanceof Player && (player = (Player)sender).isOnline()) {
                Chat.sendMessage(player, msg, new Placeholder[0]);
            }
            if (success.booleanValue()) {
                Aurora.logger().info(messages.getDbMigrateFinished());
            } else {
                Aurora.logger().severe(messages.getDbMigrateFailed());
            }
        });
    }

    @Subcommand(value="gui open")
    @CommandCompletion(value="@players @guiIds @nothing")
    @CommandPermission(value="aurora.core.admin.gui")
    public void onGuiOpen(CommandSender sender, @Flags(value="other") Player player, String id, String ... args) {
        Aurora.getExpansionManager().getExpansion(GuiExpansion.class).openGui(id, player, ArgumentParser.parseString(String.join((CharSequence)" ", args)));
    }

    @Subcommand(value="gui reload")
    @CommandPermission(value="aurora.core.admin.gui")
    public void onGuiReload(CommandSender sender) {
        MessageConfig messages = Aurora.getMsg(sender);
        GuiExpansion guiExpansion = Aurora.getExpansionManager().getExpansion(GuiExpansion.class);
        guiExpansion.reload();
        Chat.sendMessage(sender, messages.getGuiReloaded(), Placeholder.of("{amount}", guiExpansion.getGuiIds().size()));
    }

    @Subcommand(value="meta set")
    @CommandCompletion(value="@players @userMetaKeys @nothing true|false @nothing")
    @CommandPermission(value="aurora.core.admin.meta")
    public void onMetaSet(CommandSender sender, @Flags(value="other") Player player, String key, String value, @Default(value="false") Boolean silent) {
        boolean success;
        MessageConfig messages = Aurora.getMsg(sender);
        AuroraUser user = Aurora.getUserManager().getUser(player);
        try {
            double number = Double.parseDouble(value);
            success = user.getMetaData().setMeta(key, number);
        }
        catch (NumberFormatException e) {
            success = user.getMetaData().setMeta(key, value);
        }
        if (!silent.booleanValue()) {
            if (success) {
                Chat.sendMessage(sender, messages.getMetaSet(), Placeholder.of("{key}", key), Placeholder.of("{value}", value));
            } else {
                Chat.sendMessage(sender, messages.getDataNotLoadedYet(), new Placeholder[0]);
            }
        }
    }

    @Subcommand(value="meta get")
    @CommandCompletion(value="@players @userMetaKeys @nothing")
    @CommandPermission(value="aurora.core.admin.meta")
    public void onMetaGet(CommandSender sender, @Flags(value="other") Player player, String key) {
        MessageConfig messages = Aurora.getMsg(sender);
        AuroraUser user = Aurora.getUserManager().getUser(player);
        if (!user.isLoaded()) {
            Chat.sendMessage(sender, messages.getDataNotLoadedYet(), new Placeholder[0]);
            return;
        }
        Object value = user.getMetaData().getMeta(key);
        if (key == null || key.isEmpty()) {
            return;
        }
        if (value == null) {
            Chat.sendMessage(sender, messages.getMetaNotFound(), Placeholder.of("{key}", key));
            return;
        }
        sender.sendMessage(value.toString());
    }

    @Subcommand(value="meta remove")
    @CommandCompletion(value="@players @userMetaKeys true|false @nothing")
    @CommandPermission(value="aurora.core.admin.meta")
    public void onMetaRemove(CommandSender sender, @Flags(value="other") Player player, String key, @Default(value="false") Boolean silent) {
        MessageConfig messages = Aurora.getMsg(sender);
        AuroraUser user = Aurora.getUserManager().getUser(player);
        boolean success = user.getMetaData().removeMeta(key);
        if (!silent.booleanValue()) {
            if (success) {
                Chat.sendMessage(sender, messages.getMetaRemoved(), Placeholder.of("{key}", key));
            } else {
                Chat.sendMessage(sender, messages.getDataNotLoadedYet(), new Placeholder[0]);
            }
        }
    }

    @Subcommand(value="meta increment")
    @CommandCompletion(value="@players @userMetaKeys @range:1-100 true|false @nothing")
    @CommandPermission(value="aurora.core.admin.meta")
    public void onMetaIncrement(CommandSender sender, @Flags(value="other") Player player, String key, @Default(value="1") Double value, @Default(value="false") Boolean silent) {
        MessageConfig messages = Aurora.getMsg(sender);
        AuroraUser user = Aurora.getUserManager().getUser(player);
        if (key == null || key.isEmpty()) {
            return;
        }
        boolean success = user.getMetaData().incrementMeta(key, value);
        if (!silent.booleanValue()) {
            if (success) {
                Chat.sendMessage(sender, messages.getMetaIncremented(), Placeholder.of("{key}", key), Placeholder.of("{value}", value), Placeholder.of("{current}", user.getMetaData().getMeta(key, 0.0)));
            } else {
                Chat.sendMessage(sender, messages.getDataNotLoadedYet(), new Placeholder[0]);
            }
        }
    }

    @Subcommand(value="meta decrement")
    @CommandCompletion(value="@players @userMetaKeys @range:1-100 true|false true|false @nothing")
    @CommandPermission(value="aurora.core.admin.meta")
    public void onMetaDecrement(CommandSender sender, @Flags(value="other") Player player, String key, @Default(value="1") Double value, @Default(value="false") Boolean allowNegative, @Default(value="false") Boolean silent) {
        MessageConfig messages = Aurora.getMsg(sender);
        AuroraUser user = Aurora.getUserManager().getUser(player);
        if (key == null || key.isEmpty()) {
            return;
        }
        boolean success = user.getMetaData().decrementMeta(key, value, allowNegative);
        if (!silent.booleanValue()) {
            if (success) {
                Chat.sendMessage(sender, messages.getMetaDecremented(), Placeholder.of("{key}", key), Placeholder.of("{value}", value), Placeholder.of("{current}", user.getMetaData().getMeta(key, 0.0)));
            } else {
                Chat.sendMessage(sender, messages.getDataNotLoadedYet(), new Placeholder[0]);
            }
        }
    }

    @Subcommand(value="registeritem")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="aurora.core.admin.registeritem")
    public void onRegisterItem(Player player, String id) {
        if (id == null || id.isEmpty()) {
            return;
        }
        MessageConfig messages = Aurora.getMsg(player);
        player.getScheduler().run((Plugin)Aurora.getInstance(), task -> {
            ItemStack item = player.getInventory().getItemInMainHand();
            ItemExpansion expansion = Aurora.getExpansionManager().getExpansion(ItemExpansion.class);
            expansion.getItemStore().addItem(id, item);
            expansion.getItemStore().saveItems();
            Chat.sendMessage(player, messages.getItemRegistered(), Placeholder.of("{id}", "aurora:" + id));
        }, null);
    }

    @Subcommand(value="unregisteritem")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="aurora.core.admin.unregisteritem")
    public void onUnRegisterItem(CommandSender sender, String id) {
        if (id == null || id.isEmpty()) {
            return;
        }
        MessageConfig messages = Aurora.getMsg(sender);
        ItemExpansion expansion = Aurora.getExpansionManager().getExpansion(ItemExpansion.class);
        expansion.getItemStore().removeItem(id);
        expansion.getItemStore().saveItems();
        Chat.sendMessage(sender, messages.getItemUnregistered(), Placeholder.of("{id}", "aurora:" + id));
    }

    @Subcommand(value="giveitem")
    @CommandCompletion(value="@players @nothing @range:1-64 @nothing")
    @CommandPermission(value="aurora.core.admin.giveitem")
    public void onGiveItem(CommandSender sender, @Flags(value="other") Player player, String id, @Default(value="1") Integer amount) {
        if (id == null || id.isEmpty()) {
            return;
        }
        ItemExpansion expansion = Aurora.getExpansionManager().getExpansion(ItemExpansion.class);
        ItemStack item = expansion.getItemManager().resolveItem(TypeId.fromDefault(id));
        if (item == null || item.getType() == Material.AIR) {
            Chat.sendMessage(sender, "&cItem with id: &4" + id + " &cwas not found.", new Placeholder[0]);
            return;
        }
        ItemStack[] items = ItemUtils.createStacksFromAmount(item, amount);
        player.getScheduler().run((Plugin)Aurora.getInstance(), task -> {
            HashMap failed = player.getInventory().addItem(items);
            if (!failed.isEmpty()) {
                Bukkit.getRegionScheduler().run((Plugin)Aurora.getInstance(), player.getLocation(), t -> failed.forEach((index, itemStack) -> player.getWorld().dropItem(player.getLocation(), itemStack)));
            }
        }, null);
    }

    @Subcommand(value="leaderboard clear")
    @CommandCompletion(value="@leaderboards @nothing")
    @CommandPermission(value="aurora.core.admin.leaderboard.clear")
    public void onLeaderboardClear(CommandSender sender, String leaderboard) {
        LeaderboardExpansion expansion = Aurora.getExpansionManager().getExpansion(LeaderboardExpansion.class);
        MessageConfig messages = Aurora.getMsg(sender);
        if (expansion.getBoardDescriptor(leaderboard) == null) {
            Chat.sendMessage(sender, messages.getLeaderboardNotExists(), Placeholder.of("{board}", leaderboard));
            return;
        }
        expansion.clearBoard(leaderboard).thenRun(() -> Chat.sendMessage(sender, messages.getLeaderboardCleared(), Placeholder.of("{board}", leaderboard)));
    }
}

