/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.config;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.config.AuroraConfig;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageConfig
extends AuroraConfig {
    private String reloaded = "&aReloaded configuration!";
    private String dataNotLoadedYet = "&cData for this player hasn't loaded yet, try again later!";
    private String dataNotLoadedYetSelf = "&cYour data isn't loaded yet, please try again later!";
    private String playerOnlyCommand = "&cThis command can only be executed by a player!";
    private String noPermission = "&cYou don't have permission to execute this command!";
    private String invalidSyntax = "&cInvalid command syntax!";
    private String mustBeNumber = "&cArgument must be a number!";
    private String playerNotFound = "&cPlayer not found!";
    private String commandError = "&cAn error occurred while executing this command!";
    private String kickedByDbMigration = "&cUnder maintenance, please try again later!";
    private String dbMigrateStarted = "&aAttempting to migrate storage, please wait...";
    private String dbMigrateFinished = "&aStorage migration completed! It is advised to restart the server now, although it is not required.";
    private String dbMigrateFailed = "&cStorage migration failed! Please check the console for more information.";
    private String guiReloaded = "&aSuccessfully reloaded &2{amount} &aguis";
    private String metaSet = "&aSet meta key &2{key} &ato &2{value}";
    private String metaRemoved = "&aRemoved meta key &2{key}";
    private String metaIncremented = "&aIncremented meta key &2{key} &aby &2{value}. Current value: &2{current}";
    private String metaDecremented = "&aDecremented meta key &2{key} &aby &2{value}. Current value: &2{current}";
    private String metaNotFound = "&cMeta with key: &4{key} &cwas not found";
    private String stashAvailable = "&aYou have unclaimed items in your stash!";
    private String stashItemAdded = "&aItems are added to the stash!";
    private String stashItemsCleared = "&aItems cleared!";
    private String itemRegistered = "&aItem registered with id: &2{id}!";
    private String itemUnregistered = "&aItem unregistered with id: &2{id}!";
    private String itemNotFound = "&cItem with id &4{id} &cwas not found";
    private String leaderboardNotExists = "&cLeaderboard with id: &4{board} &cdoes not exists!";
    private String leaderboardCleared = "&aLeaderboard with id: &2{board} &acleared and will be updated shortly!";
    private String unknownCommand = "&cAuroraLib doesn't have a command like that.";
    private String localeNotSupported = "&cThis language isn't supported at the moment";
    private String localeInvalid = "&cInvalid language code";
    private String localeChanged = "&cLocale changed to english.";

    public MessageConfig(String language) {
        super(new File(Aurora.getInstance().getDataFolder(), "messages_" + language + ".yml"), Map.of("language", language));
    }

    public static void saveDefault(String language) {
        File file = new File(Aurora.getInstance().getDataFolder(), "messages_" + language + ".yml");
        if (!file.exists()) {
            try {
                Aurora.getInstance().saveResource("messages_" + language + ".yml", false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    protected List<Consumer<YamlConfiguration>> getMigrationSteps(Map<String, Object> params) {
        return List.of(yaml -> {
            String language = (String)params.get("language");
            try (InputStream in = this.getInternalFile(language);){
                YamlConfiguration original = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(in));
                for (String key : original.getKeys(false)) {
                    if (yaml.contains(key)) continue;
                    yaml.set(key, original.get(key));
                }
            }
            catch (Exception e) {
                Aurora.logger().severe("Failed to run migrations on messages_" + language + ".yml");
                e.printStackTrace();
            }
        });
    }

    private InputStream getInternalFile(String language) {
        InputStream in = Aurora.getInstance().getResource("messages_" + language + ".yml");
        if (in == null) {
            return Aurora.getInstance().getResource("messages_en.yml");
        }
        return in;
    }

    public Map<String, String> toFlatMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : this.getRawConfig().getKeys(false)) {
            if (key.equals("custom")) {
                for (String customKey : this.getRawConfig().getConfigurationSection("custom").getKeys(true)) {
                    map.put(customKey, this.getRawConfig().getString("custom." + customKey));
                }
                continue;
            }
            map.put(key, this.getRawConfig().getString(key));
        }
        return map;
    }

    public String getReloaded() {
        return this.reloaded;
    }

    public String getDataNotLoadedYet() {
        return this.dataNotLoadedYet;
    }

    public String getDataNotLoadedYetSelf() {
        return this.dataNotLoadedYetSelf;
    }

    public String getPlayerOnlyCommand() {
        return this.playerOnlyCommand;
    }

    public String getNoPermission() {
        return this.noPermission;
    }

    public String getInvalidSyntax() {
        return this.invalidSyntax;
    }

    public String getMustBeNumber() {
        return this.mustBeNumber;
    }

    public String getPlayerNotFound() {
        return this.playerNotFound;
    }

    public String getCommandError() {
        return this.commandError;
    }

    public String getKickedByDbMigration() {
        return this.kickedByDbMigration;
    }

    public String getDbMigrateStarted() {
        return this.dbMigrateStarted;
    }

    public String getDbMigrateFinished() {
        return this.dbMigrateFinished;
    }

    public String getDbMigrateFailed() {
        return this.dbMigrateFailed;
    }

    public String getGuiReloaded() {
        return this.guiReloaded;
    }

    public String getMetaSet() {
        return this.metaSet;
    }

    public String getMetaRemoved() {
        return this.metaRemoved;
    }

    public String getMetaIncremented() {
        return this.metaIncremented;
    }

    public String getMetaDecremented() {
        return this.metaDecremented;
    }

    public String getMetaNotFound() {
        return this.metaNotFound;
    }

    public String getStashAvailable() {
        return this.stashAvailable;
    }

    public String getStashItemAdded() {
        return this.stashItemAdded;
    }

    public String getStashItemsCleared() {
        return this.stashItemsCleared;
    }

    public String getItemRegistered() {
        return this.itemRegistered;
    }

    public String getItemUnregistered() {
        return this.itemUnregistered;
    }

    public String getItemNotFound() {
        return this.itemNotFound;
    }

    public String getLeaderboardNotExists() {
        return this.leaderboardNotExists;
    }

    public String getLeaderboardCleared() {
        return this.leaderboardCleared;
    }

    public String getUnknownCommand() {
        return this.unknownCommand;
    }

    public String getLocaleNotSupported() {
        return this.localeNotSupported;
    }

    public String getLocaleInvalid() {
        return this.localeInvalid;
    }

    public String getLocaleChanged() {
        return this.localeChanged;
    }
}

