/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.expansions.economy;

import com.Zrips.CMI.CMI;
import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.dependency.Dep;
import gg.auroramc.aurora.api.dependency.DependencyManager;
import gg.auroramc.aurora.api.expansions.AuroraExpansion;
import gg.auroramc.aurora.expansions.economy.AuroraEconomy;
import gg.auroramc.aurora.expansions.economy.providers.CMIEconomy;
import gg.auroramc.aurora.expansions.economy.providers.CoinsEngineEconomy;
import gg.auroramc.aurora.expansions.economy.providers.EcoBitsEconomy;
import gg.auroramc.aurora.expansions.economy.providers.EliteMobsEconomy;
import gg.auroramc.aurora.expansions.economy.providers.EssentialsEconomy;
import gg.auroramc.aurora.expansions.economy.providers.PlayerPointsEconomy;
import gg.auroramc.aurora.expansions.economy.providers.RoyaleEco;
import gg.auroramc.aurora.expansions.economy.providers.RoyaleEconomyBank;
import gg.auroramc.aurora.expansions.economy.providers.VaultEconomy;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class EconomyExpansion
implements AuroraExpansion {
    private final Map<String, AuroraEconomy> economies = new ConcurrentHashMap<String, AuroraEconomy>();
    private String defaultEconomy = null;

    @Override
    public void hook() {
        if (DependencyManager.hasDep(Dep.VAULT)) {
            this.economies.put(Dep.VAULT.getId(), new VaultEconomy());
            this.defaultEconomy = Dep.VAULT.getId();
        }
        if (DependencyManager.hasDep(Dep.ESSENTIALS) && DependencyManager.getEssentials().isEconomyEnabled()) {
            this.economies.put(Dep.ESSENTIALS.getId(), new EssentialsEconomy());
            this.defaultEconomy = Dep.ESSENTIALS.getId();
        } else if (DependencyManager.hasDep(Dep.CMI) && CMI.getInstance().getEconomyManager().isEnabled()) {
            this.economies.put(Dep.CMI.getId(), new CMIEconomy());
            this.defaultEconomy = Dep.CMI.getId();
        }
        if (DependencyManager.hasDep(Dep.ELITEMOBS)) {
            this.economies.put(Dep.ELITEMOBS.getId(), new EliteMobsEconomy());
            if (this.defaultEconomy == null) {
                this.defaultEconomy = Dep.ELITEMOBS.getId();
            }
        }
        if (DependencyManager.hasDep("EcoBits")) {
            this.economies.put("EcoBits", new EcoBitsEconomy());
            if (this.defaultEconomy == null) {
                this.defaultEconomy = "EcoBits";
            }
        }
        if (DependencyManager.hasDep(Dep.PLAYER_POINTS)) {
            this.economies.put(Dep.PLAYER_POINTS.getId(), new PlayerPointsEconomy());
            if (this.defaultEconomy == null) {
                this.defaultEconomy = Dep.PLAYER_POINTS.getId();
            }
        }
        if (DependencyManager.hasDep(Dep.COINS_ENGINE)) {
            this.economies.put(Dep.COINS_ENGINE.getId(), new CoinsEngineEconomy());
            if (this.defaultEconomy == null) {
                this.defaultEconomy = Dep.COINS_ENGINE.getId();
            }
        }
        if (DependencyManager.hasDep("RoyaleEconomy")) {
            this.economies.put("RoyaleEconomyBank", new RoyaleEconomyBank());
            this.economies.put("RoyaleEconomy", new RoyaleEco());
            if (this.defaultEconomy == null) {
                this.defaultEconomy = "RoyaleEconomy";
            }
        }
        if (!Aurora.getLibConfig().getDefaultEconomyProvider().equals("auto-detect")) {
            if (this.economies.containsKey(Aurora.getLibConfig().getDefaultEconomyProvider())) {
                this.defaultEconomy = Aurora.getLibConfig().getDefaultEconomyProvider();
            } else {
                Aurora.logger().severe("Invalid default economy provider in config: " + Aurora.getLibConfig().getDefaultEconomyProvider() + ", using " + this.defaultEconomy + " instead.");
            }
        }
        Aurora.logger().info("Loaded " + this.economies.size() + " economy providers. " + String.join((CharSequence)", ", this.economies.keySet()));
        Aurora.logger().info("Using " + this.defaultEconomy + " as the default economy provider.");
    }

    @Override
    public boolean canHook() {
        return DependencyManager.hasAnyDep(Dep.ESSENTIALS, Dep.CMI, Dep.VAULT, Dep.ELITEMOBS, Dep.PLAYER_POINTS, Dep.COINS_ENGINE) || DependencyManager.hasAnyDep("EcoBits", "RoyaleEconomy");
    }

    public AuroraEconomy getEconomy(String economyPlugin) {
        return this.economies.get(economyPlugin);
    }

    public AuroraEconomy getEconomy(Dep economyPlugin) {
        return this.economies.get(economyPlugin.getId());
    }

    public AuroraEconomy getDefaultEconomy() {
        return this.economies.get(this.defaultEconomy);
    }

    public AuroraEconomy getOrDefaultEconomy(String economyPlugin) {
        return this.economies.getOrDefault(economyPlugin, this.getDefaultEconomy());
    }

    public void addEconomy(String economyPlugin, AuroraEconomy economy) {
        this.economies.put(economyPlugin, economy);
    }

    public void addEconomy(String economyPlugin, AuroraEconomy economy, boolean isDefault) {
        this.economies.put(economyPlugin, economy);
        if (isDefault) {
            this.defaultEconomy = economyPlugin;
        }
    }

    public String getDefaultEconomyId() {
        return this.defaultEconomy;
    }

    public Set<String> getEconomyIds() {
        return this.economies.keySet();
    }
}

