/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.expansions.economy.providers;

import gg.auroramc.aurora.api.util.ThreadSafety;
import gg.auroramc.aurora.expansions.economy.AuroraEconomy;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultEconomy
implements AuroraEconomy {
    private final Economy economy = this.resolveEconomy();

    @Override
    public void withdraw(Player player, String currency, double amount) {
        this.economy.withdrawPlayer((OfflinePlayer)player, amount);
    }

    @Override
    public void deposit(Player player, String currency, double amount) {
        this.economy.depositPlayer((OfflinePlayer)player, amount);
    }

    @Override
    public double getBalance(Player player, String currency) {
        return this.economy.getBalance((OfflinePlayer)player);
    }

    @Override
    public boolean hasBalance(Player player, String currency, double amount) {
        return this.economy.getBalance((OfflinePlayer)player) >= amount;
    }

    @Override
    public boolean supportsCurrency() {
        return false;
    }

    @Override
    public boolean validateCurrency(String currency) {
        return false;
    }

    private Economy resolveEconomy() {
        if (Bukkit.getServer().getPluginManager().getPlugin("Vault") == null) {
            return null;
        }
        RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return null;
        }
        return (Economy)rsp.getProvider();
    }

    @Override
    public ThreadSafety getThreadSafety() {
        return ThreadSafety.SYNC_ONLY;
    }
}

