/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.expansions.entity;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.dependency.Dep;
import gg.auroramc.aurora.api.dependency.DependencyManager;
import gg.auroramc.aurora.api.entity.EntityManager;
import gg.auroramc.aurora.api.entity.EntityResolver;
import gg.auroramc.aurora.api.expansions.AuroraExpansion;
import gg.auroramc.aurora.expansions.entity.resolvers.ecomobs.EcoMobsEntityResolver;
import gg.auroramc.aurora.expansions.entity.resolvers.elitemobs.EliteMobsResolver;
import gg.auroramc.aurora.expansions.entity.resolvers.mythicmobs.MythicEntityResolver;

public class EntityExpansion
implements AuroraExpansion {
    private EntityManager entityManager;

    @Override
    public void hook() {
        this.entityManager = new EntityManager();
        if (DependencyManager.hasDep(Dep.MYTHICMOBS)) {
            this.entityManager.registerResolver(Dep.MYTHICMOBS, (EntityResolver)new MythicEntityResolver());
            Aurora.logger().debug("Hooked into MythicMobs for entity resolvers.");
        }
        if (DependencyManager.hasEveryDep("Eco", "EcoMobs")) {
            this.entityManager.registerResolver("ecomobs", (EntityResolver)new EcoMobsEntityResolver());
            Aurora.logger().debug("Hooked into EcoMobs for entity resolvers.");
        }
        if (DependencyManager.hasDep(Dep.ELITEMOBS)) {
            this.entityManager.registerResolver(Dep.ELITEMOBS, (EntityResolver)new EliteMobsResolver());
            Aurora.logger().debug("Hooked into EliteMobs for entity resolvers.");
        }
    }

    @Override
    public boolean canHook() {
        return true;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }
}

