/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.expansions.gui;

import com.google.common.collect.Maps;
import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.expansions.AuroraExpansion;
import gg.auroramc.aurora.expansions.gui.AuroraGui;
import gg.auroramc.aurora.expansions.gui.Gui;
import gg.auroramc.aurora.expansions.gui.GuiConfig;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class GuiExpansion
implements AuroraExpansion {
    private Map<String, Gui> guiMap = Maps.newConcurrentMap();
    private Map<String, Function<Player, AuroraGui>> customGuiMap = Maps.newConcurrentMap();

    @Override
    public void hook() {
        this.reload();
    }

    public void registerCustomGui(String id, Function<Player, AuroraGui> supplier) {
        this.customGuiMap.put(id, supplier);
    }

    public void openGui(String id, Player player, @Nullable Map<String, String> args) {
        Gui gui = this.guiMap.get(id);
        if (gui == null) {
            Function<Player, AuroraGui> customGui = this.customGuiMap.get(id);
            if (customGui != null) {
                customGui.apply(player).open(player, args);
            }
        } else {
            gui.open(player, args);
        }
    }

    public void refreshPlayerGuis(UUID uuid) {
        if (Bukkit.getServer().isStopping()) {
            return;
        }
        this.guiMap.forEach((id, gui) -> gui.refreshForPlayer(uuid));
    }

    public void refreshPlayerGuis(Player player) {
        this.refreshPlayerGuis(player.getUniqueId());
    }

    public Collection<String> getGuiIds() {
        return this.guiMap.keySet();
    }

    @Override
    public void reload() {
        this.guiMap.values().forEach(Gui::dispose);
        this.guiMap.clear();
        File dir = new File(Aurora.getInstance().getDataFolder(), "gui/menus");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.loadFolder(dir);
    }

    private void loadFolder(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.getName().endsWith(".yml")) {
                    GuiConfig config = new GuiConfig(file);
                    config.load();
                    String id = file.getName().replace(".yml", "");
                    if (!Pattern.compile("^[a-z0-9_]+$").matcher(id).matches()) {
                        Aurora.getInstance().getLogger().warning("Invalid gui id: " + id + ", Only lowercase letters, numbers, and underscores are allowed.");
                        continue;
                    }
                    if (this.guiMap.containsKey(id)) {
                        Aurora.getInstance().getLogger().warning("Duplicate gui id: " + id + ", Skipping...");
                        continue;
                    }
                    this.guiMap.put(id, new Gui(config, id));
                    Aurora.logger().debug("Loaded gui: " + id);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.loadFolder(file);
            }
        }
    }

    @Override
    public boolean canHook() {
        return true;
    }
}

