/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.expansions.item;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.dependency.Dep;
import gg.auroramc.aurora.api.dependency.DependencyManager;
import gg.auroramc.aurora.api.expansions.AuroraExpansion;
import gg.auroramc.aurora.api.item.ItemManager;
import gg.auroramc.aurora.api.item.ItemResolver;
import gg.auroramc.aurora.config.Config;
import gg.auroramc.aurora.expansions.item.resolvers.AuroraItemResolver;
import gg.auroramc.aurora.expansions.item.resolvers.CustomFishingItemResolver;
import gg.auroramc.aurora.expansions.item.resolvers.EcoItemsResolver;
import gg.auroramc.aurora.expansions.item.resolvers.EvenMoreFishItemResolver;
import gg.auroramc.aurora.expansions.item.resolvers.ExecutableBlocksResolver;
import gg.auroramc.aurora.expansions.item.resolvers.ExecutableItemsResolver;
import gg.auroramc.aurora.expansions.item.resolvers.HdbItemResolver;
import gg.auroramc.aurora.expansions.item.resolvers.ItemEditResolver;
import gg.auroramc.aurora.expansions.item.resolvers.ItemsAdderResolver;
import gg.auroramc.aurora.expansions.item.resolvers.KGeneratorsResolver;
import gg.auroramc.aurora.expansions.item.resolvers.MMOItemResolver;
import gg.auroramc.aurora.expansions.item.resolvers.MythicItemResolver;
import gg.auroramc.aurora.expansions.item.resolvers.NexoItemResolver;
import gg.auroramc.aurora.expansions.item.resolvers.OraxenItemResolver;
import gg.auroramc.aurora.expansions.item.store.ItemStore;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ItemExpansion
implements AuroraExpansion {
    private ItemManager itemManager;
    private ItemStore itemStore;

    @Override
    public void hook() {
        this.itemManager = new ItemManager();
        this.itemStore = new ItemStore("itemstore.yml");
        Set<String> enabledMatchers = Aurora.getLibConfig().getItemMatchers();
        if (DependencyManager.hasDep(Dep.CUSTOMFISHING) && enabledMatchers.contains(Dep.CUSTOMFISHING.getId())) {
            this.itemManager.registerResolver(Dep.CUSTOMFISHING, (ItemResolver)new CustomFishingItemResolver());
        }
        if (DependencyManager.hasDep(Dep.EXECUTABLE_BLOCKS) && enabledMatchers.contains(Dep.EXECUTABLE_BLOCKS.getId())) {
            this.itemManager.registerResolver("eb", (ItemResolver)new ExecutableBlocksResolver());
        }
        if (DependencyManager.hasDep(Dep.EVEN_MORE_FISH) && enabledMatchers.contains(Dep.EVEN_MORE_FISH.getId())) {
            this.itemManager.registerResolver("emf", (ItemResolver)new EvenMoreFishItemResolver());
        }
        if (DependencyManager.hasDep(Dep.EXECUTABLE_ITEMS) && enabledMatchers.contains(Dep.EXECUTABLE_ITEMS.getId())) {
            this.itemManager.registerResolver("ei", (ItemResolver)new ExecutableItemsResolver());
        }
        if (DependencyManager.hasDep(Dep.MMOITEMS) && enabledMatchers.contains(Dep.MMOITEMS.getId())) {
            this.itemManager.registerResolver(Dep.MMOITEMS, (ItemResolver)new MMOItemResolver());
        }
        if (DependencyManager.hasDep(Dep.MYTHICMOBS) && enabledMatchers.contains(Dep.MYTHICMOBS.getId())) {
            this.itemManager.registerResolver(Dep.MYTHICMOBS, (ItemResolver)new MythicItemResolver());
        }
        if (DependencyManager.hasDep(Dep.ECO) && enabledMatchers.contains(Dep.ECO.getId())) {
            this.itemManager.registerResolver(Dep.ECO, (ItemResolver)new EcoItemsResolver());
        }
        if (DependencyManager.hasDep(Dep.NEXO) && enabledMatchers.contains(Dep.NEXO.getId())) {
            this.itemManager.registerResolver(Dep.NEXO, (ItemResolver)new NexoItemResolver());
        }
        if (DependencyManager.hasDep(Dep.ORAXEN) && enabledMatchers.contains(Dep.ORAXEN.getId())) {
            this.itemManager.registerResolver(Dep.ORAXEN, (ItemResolver)new OraxenItemResolver());
        }
        if (DependencyManager.hasDep("ItemsAdder") && enabledMatchers.contains("ItemsAdder")) {
            this.itemManager.registerResolver("ia", (ItemResolver)new ItemsAdderResolver());
        }
        if (DependencyManager.hasDep(Dep.ITEM_EDIT) && enabledMatchers.contains(Dep.ITEM_EDIT.getId())) {
            this.itemManager.registerResolver(Dep.ITEM_EDIT, (ItemResolver)new ItemEditResolver());
        }
        if (DependencyManager.hasDep("KGenerators") && enabledMatchers.contains("KGenerators")) {
            this.itemManager.registerResolver("kgenerators", (ItemResolver)new KGeneratorsResolver());
        }
        this.initAuroraItemResolver();
        if (DependencyManager.hasDep(Dep.HEAD_DATABASE) && enabledMatchers.contains(Dep.HEAD_DATABASE.getId())) {
            HdbItemResolver hdbResolver = new HdbItemResolver();
            Bukkit.getPluginManager().registerEvents((Listener)hdbResolver, (Plugin)Aurora.getInstance());
            this.itemManager.registerResolver("hdb", (ItemResolver)hdbResolver);
        }
        Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)Aurora.getInstance(), t -> Aurora.logger().info("Registered resolvers: " + String.join((CharSequence)", ", this.itemManager.getResolvers().stream().map(r -> r.plugin() + ":" + r.priority()).toList())), 20L);
    }

    @Override
    public boolean canHook() {
        return true;
    }

    private void initAuroraItemResolver() {
        Config.ItemIdResolverConfig itemConfig = Aurora.getLibConfig().getAuroraItems();
        this.itemManager.registerResolver("aurora", (ItemResolver)new AuroraItemResolver(this.itemStore, itemConfig.getEnableIdResolver()));
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public ItemStore getItemStore() {
        return this.itemStore;
    }
}

