/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.expansions.leaderboard;

import com.google.common.collect.Maps;
import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.expansions.AuroraExpansion;
import gg.auroramc.aurora.api.placeholder.PlaceholderHandlerRegistry;
import gg.auroramc.aurora.api.user.AuroraUser;
import gg.auroramc.aurora.api.user.storage.sql.MySqlStorage;
import gg.auroramc.aurora.expansions.leaderboard.LbPlaceholderHandler;
import gg.auroramc.aurora.expansions.leaderboard.model.LbEntry;
import gg.auroramc.aurora.expansions.leaderboard.storage.BoardValue;
import gg.auroramc.aurora.expansions.leaderboard.storage.LeaderboardStorage;
import gg.auroramc.aurora.expansions.leaderboard.storage.sqlite.SqliteLeaderboardStorage;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public class LeaderboardExpansion
implements AuroraExpansion,
Listener {
    private final Map<UUID, Object> updateLocks = Maps.newConcurrentMap();
    private final Map<String, List<LbEntry>> boards = Maps.newConcurrentMap();
    private final Map<String, LbDescriptor> descriptors = Maps.newConcurrentMap();
    private final Map<String, Long> boardSizes = Maps.newConcurrentMap();
    private volatile LeaderboardStorage storage;

    public void setStorage(LeaderboardStorage storage) {
        this.storage.dispose();
        this.storage = storage;
    }

    @Override
    public void hook() {
        this.storage = Aurora.getLibConfig().getStorageType().equalsIgnoreCase("mysql") ? (MySqlStorage)Aurora.getUserManager().getStorage() : new SqliteLeaderboardStorage();
        PlaceholderHandlerRegistry.addHandler(new LbPlaceholderHandler(this));
        Permission wildcard = new Permission("aurora.leaderboard.prevent.*", PermissionDefault.FALSE);
        Bukkit.getPluginManager().addPermission(wildcard);
        for (String board : this.descriptors.keySet()) {
            Permission perm = new Permission("aurora.leaderboard.prevent." + board, PermissionDefault.FALSE);
            Bukkit.getPluginManager().addPermission(perm);
            perm.addParent(wildcard, true);
        }
        for (String board : this.descriptors.keySet()) {
            this.boards.putIfAbsent(board, List.of());
            this.boards.put(board, this.storage.getTopEntries(board, this.descriptors.get((Object)board).cacheSize));
            this.boardSizes.put(board, this.storage.getTotalEntryCount(board));
        }
    }

    public void updateLeaderBoards() {
        for (String board : this.descriptors.keySet()) {
            this.boards.put(board, this.storage.getTopEntries(board, this.descriptors.get((Object)board).cacheSize));
            this.boardSizes.put(board, this.storage.getTotalEntryCount(board));
        }
        Bukkit.getOnlinePlayers().forEach(player -> {
            if (Bukkit.isStopping() || Aurora.isDisabling()) {
                return;
            }
            AuroraUser user = Aurora.getUserManager().getUser(player.getUniqueId());
            user.getLeaderboardEntries().putAll(this.storage.getPlayerEntries(player.getUniqueId()));
        });
        Aurora.logger().debug("Leaderboards updated.");
    }

    @Override
    public boolean canHook() {
        return true;
    }

    private Object getUpdateLock(UUID uuid) {
        return this.updateLocks.computeIfAbsent(uuid, k -> new Object());
    }

    public void registerBoard(String board, Function<AuroraUser, Double> valueMapper, int cacheSize) {
        this.registerBoard(board, valueMapper, e -> AuroraAPI.formatNumber(e.getValue()), cacheSize, 0.0);
    }

    public void registerBoard(String board, Function<AuroraUser, Double> valueMapper, Function<LbEntry, String> formatMapper, int cacheSize) {
        this.registerBoard(board, valueMapper, formatMapper, cacheSize, 0.0);
    }

    public void registerBoard(String board, Function<AuroraUser, Double> valueMapper, Function<LbEntry, String> formatMapper, int cacheSize, double minValue) {
        this.descriptors.put(board, new LbDescriptor(board, valueMapper, formatMapper, cacheSize, minValue));
    }

    public List<LbEntry> getBoard(String board) {
        return this.boards.getOrDefault(board, List.of());
    }

    public long getBoardSize(String board) {
        return this.boardSizes.getOrDefault(board, 0L);
    }

    public CompletableFuture<Map<String, LbEntry>> loadUser(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            Object object = this.getUpdateLock(uuid);
            synchronized (object) {
                return this.storage.getPlayerEntries(uuid);
            }
        });
    }

    @Nullable
    public LbDescriptor getBoardDescriptor(String board) {
        return this.descriptors.get(board);
    }

    public CompletableFuture<Void> clearBoard(String board) {
        return CompletableFuture.runAsync(() -> this.storage.clearBoard(board));
    }

    public CompletableFuture<Void> bulkUpdateUsers(Map<UUID, Collection<String>> data) {
        return CompletableFuture.runAsync(() -> {
            HashMap<UUID, Set<BoardValue>> toUpdate = new HashMap<UUID, Set<BoardValue>>(data.size());
            for (Map.Entry entry : data.entrySet()) {
                AuroraUser user = Aurora.getUserManager().getUser((UUID)entry.getKey());
                if (user == null || !user.isLoaded()) continue;
                Player player = user.getPlayer();
                HashSet<BoardValue> values = new HashSet<BoardValue>(((Collection)entry.getValue()).size());
                for (String board : (Collection)entry.getValue()) {
                    this.populateBoardValues(user, player, values, board);
                }
                if (values.isEmpty()) continue;
                toUpdate.put((UUID)entry.getKey(), values);
            }
            if (!toUpdate.isEmpty()) {
                this.storage.bulkUpdateEntries(toUpdate);
            }
        });
    }

    private void populateBoardValues(AuroraUser user, Player player, HashSet<BoardValue> values, String board) {
        if (player != null && player.hasPermission("aurora.leaderboard.prevent." + board)) {
            return;
        }
        double value = this.descriptors.get((Object)board).valueMapper.apply(user);
        if (value >= this.descriptors.get((Object)board).minValue) {
            values.add(new BoardValue(board, value));
        }
    }

    public CompletableFuture<Void> updateUser(AuroraUser user, Collection<String> updateBoards) {
        return CompletableFuture.runAsync(() -> {
            Object object = this.getUpdateLock(user.getUniqueId());
            synchronized (object) {
                Player player = user.getPlayer();
                HashSet<BoardValue> toUpdate = new HashSet<BoardValue>(updateBoards.isEmpty() ? this.descriptors.keySet().size() : updateBoards.size());
                for (String board : updateBoards.isEmpty() ? this.descriptors.keySet() : updateBoards) {
                    this.populateBoardValues(user, player, toUpdate, board);
                }
                if (!toUpdate.isEmpty()) {
                    this.storage.updateEntry(user.getUniqueId(), toUpdate);
                }
            }
        });
    }

    public CompletableFuture<Void> updateUser(AuroraUser user, String ... updateBoards) {
        Player player = user.getPlayer();
        for (String board : updateBoards.length == 0 ? this.descriptors.keySet() : Arrays.asList(updateBoards)) {
            double value;
            if (player != null && player.hasPermission("aurora.leaderboard.prevent." + board) || !((value = this.descriptors.get((Object)board).valueMapper.apply(user).doubleValue()) >= this.descriptors.get((Object)board).minValue)) continue;
            Map<String, LbEntry> entries = user.getLeaderboardEntries();
            if (entries.containsKey(board)) {
                entries.get(board).setValue(value);
                continue;
            }
            entries.put(board, new LbEntry(user.getUniqueId(), player.getName(), board, value, 0L));
        }
        return CompletableFuture.completedFuture(null);
    }

    public String formatValue(LbEntry entry) {
        Function<LbEntry, String> mapper = this.descriptors.get((Object)entry.getBoard()).formatMapper;
        if (mapper != null) {
            return mapper.apply(entry);
        }
        return AuroraAPI.formatNumber(entry.getValue());
    }

    public Set<String> getBoards() {
        return this.descriptors.keySet();
    }

    public String getEmptyPlaceholder() {
        return Aurora.getLibConfig().getLeaderboards().getEmptyPlaceholder();
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.updateLocks.remove(event.getPlayer().getUniqueId());
    }

    public void dispose() {
        this.storage.dispose();
    }

    public record LbDescriptor(String name, Function<AuroraUser, Double> valueMapper, Function<LbEntry, String> formatMapper, int cacheSize, double minValue) {
    }
}

