/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.expansions.leaderboard.storage.sqlite;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.expansions.leaderboard.model.LbEntry;
import gg.auroramc.aurora.expansions.leaderboard.storage.BoardValue;
import gg.auroramc.aurora.expansions.leaderboard.storage.LeaderboardStorage;
import gg.auroramc.aurora.libs.hikari.HikariConfig;
import gg.auroramc.aurora.libs.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;

public class SqliteLeaderboardStorage
implements LeaderboardStorage {
    private HikariDataSource dataSource;
    private static final String table = "        CREATE TABLE IF NOT EXISTS aurora_leaderboard\n        (\n            id          INTEGER PRIMARY KEY AUTOINCREMENT,\n            player_uuid VARCHAR(36) NOT NULL,\n            name        VARCHAR(50) NOT NULL,\n            board       VARCHAR(50) NOT NULL,\n            value       DOUBLE DEFAULT 0.0,\n            UNIQUE (player_uuid, board)\n        );\n";
    private static final String[] indexes = new String[]{"CREATE INDEX idx_board_value ON aurora_leaderboard (board, value);", "CREATE INDEX idx_player_board ON aurora_leaderboard (player_uuid, board);"};

    public SqliteLeaderboardStorage() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl("jdbc:sqlite:" + String.valueOf(Aurora.getInstance().getDataFolder()) + "/leaderboards.db");
        config.setConnectionTestQuery("SELECT 1");
        config.setMaximumPoolSize(10);
        config.setPoolName("aurora-leaderboard-pool");
        config.setDriverClassName("org.sqlite.JDBC");
        this.dataSource = new HikariDataSource(config);
        try (Connection conn = this.connection();
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate("PRAGMA busy_timeout = 5000;");
            stmt.executeUpdate("PRAGMA journal_mode = WAL;");
            stmt.executeUpdate("PRAGMA synchronous = NORMAL;");
            stmt.executeUpdate("PRAGMA journal_size_limit = 6144000;");
            stmt.executeUpdate(table);
            for (String index : indexes) {
                this.createIndexIfNotExists(conn, index);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void createIndexIfNotExists(Connection conn, String index) throws SQLException {
        block19: {
            String indexName = index.split(" ")[2];
            String checkIndexQuery = "PRAGMA index_list('aurora_leaderboard')";
            try (Statement stmt = conn.createStatement();
                 ResultSet rs = stmt.executeQuery(checkIndexQuery);){
                boolean exists = false;
                while (rs.next()) {
                    if (!indexName.equals(rs.getString("name"))) continue;
                    exists = true;
                    break;
                }
                if (exists) break block19;
                try (Statement createStmt = conn.createStatement();){
                    createStmt.executeUpdate(index);
                }
            }
        }
    }

    private Connection connection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to connect to the database", e);
        }
    }

    @Override
    public List<LbEntry> getTopEntries(String board, int limit) {
        ArrayList<LbEntry> entries = new ArrayList<LbEntry>();
        String query = "SELECT player_uuid, name, board, value, RANK() OVER (ORDER BY value DESC) as position FROM aurora_leaderboard WHERE board = ? ORDER BY value DESC LIMIT ?";
        try (Connection conn = this.connection();
             PreparedStatement ps = conn.prepareStatement(query);){
            ps.setString(1, board);
            ps.setInt(2, limit);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                UUID uuid = UUID.fromString(rs.getString("player_uuid"));
                String name = rs.getString("name");
                String boardName = rs.getString("board");
                double value = rs.getDouble("value");
                long position = rs.getLong("position");
                entries.add(new LbEntry(uuid, name, boardName, value, position));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return entries;
    }

    @Override
    public Map<String, LbEntry> getPlayerEntries(UUID uuid) {
        HashMap<String, LbEntry> entries = new HashMap<String, LbEntry>();
        String query = "    WITH RankedEntries AS (\n        SELECT\n            player_uuid,\n            name,\n            board,\n            value,\n            RANK() OVER (PARTITION BY board ORDER BY value DESC) as position\n        FROM aurora_leaderboard\n    )\n    SELECT player_uuid, name, board, value, position\n    FROM RankedEntries\n    WHERE player_uuid = ?\n";
        try (Connection conn = this.connection();
             PreparedStatement ps = conn.prepareStatement(query);){
            ps.setString(1, uuid.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String boardName = rs.getString("board");
                String name = rs.getString("name");
                double value = rs.getDouble("value");
                long position = rs.getLong("position");
                entries.put(boardName, new LbEntry(uuid, name, boardName, value, position));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return entries;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getTotalEntryCount(String board) {
        String query = "SELECT COUNT(*) as total FROM aurora_leaderboard WHERE board = ?";
        try (Connection conn = this.connection();
             PreparedStatement ps = conn.prepareStatement(query);){
            ps.setString(1, board);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return 0L;
            long l = rs.getLong("total");
            return l;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    @Override
    public void clearBoard(String board) {
        String query = "DELETE FROM aurora_leaderboard WHERE board = ?";
        try (Connection conn = this.connection();
             PreparedStatement ps = conn.prepareStatement(query);){
            ps.setString(1, board);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateEntry(UUID uuid, Set<BoardValue> values) {
        String query = "INSERT INTO aurora_leaderboard (player_uuid, name, board, value) VALUES (?, ?, ?, ?) ON CONFLICT(player_uuid, board) DO UPDATE SET value = ?, name = ?";
        try (Connection conn = this.connection();
             PreparedStatement ps = conn.prepareStatement(query);){
            String name = Bukkit.getOfflinePlayer((UUID)uuid).getName();
            for (BoardValue boardValue : values) {
                ps.setString(1, uuid.toString());
                ps.setString(2, name);
                ps.setString(3, boardValue.board());
                ps.setDouble(4, boardValue.value());
                ps.setDouble(5, boardValue.value());
                ps.setString(6, name);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void bulkUpdateEntries(Map<UUID, Set<BoardValue>> values) {
        String query = "INSERT INTO aurora_leaderboard (player_uuid, name, board, value) VALUES (?, ?, ?, ?) ON CONFLICT(player_uuid, board) DO UPDATE SET value = ?, name = ?";
        int BATCH_SIZE = 50;
        int batchCount = 0;
        try (Connection conn = this.connection();
             PreparedStatement ps = conn.prepareStatement(query);){
            for (Map.Entry<UUID, Set<BoardValue>> entry : values.entrySet()) {
                String name = Bukkit.getOfflinePlayer((UUID)entry.getKey()).getName();
                for (BoardValue boardValue : entry.getValue()) {
                    ps.setString(1, entry.getKey().toString());
                    ps.setString(2, name);
                    ps.setString(3, boardValue.board());
                    ps.setDouble(4, boardValue.value());
                    ps.setDouble(5, boardValue.value());
                    ps.setString(6, name);
                    ps.addBatch();
                    if (++batchCount < 50) continue;
                    ps.executeBatch();
                    ps.clearBatch();
                    batchCount = 0;
                }
            }
            if (batchCount > 0) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dispose() {
        this.dataSource.close();
    }
}

