/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.expansions.numberformat;

import gg.auroramc.aurora.Aurora;
import gg.auroramc.aurora.api.expansions.AuroraExpansion;
import gg.auroramc.aurora.api.util.NumberFormat;
import gg.auroramc.aurora.config.NumberFormatConfig;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NumberFormatExpansion
implements AuroraExpansion {
    private final Map<Locale, NumberFormat> intFormats = new ConcurrentHashMap<Locale, NumberFormat>();
    private final Map<Locale, NumberFormat> doubleFormats = new ConcurrentHashMap<Locale, NumberFormat>();
    private final Map<Locale, NumberFormat> shortFormats = new ConcurrentHashMap<Locale, NumberFormat>();

    @Override
    public void hook() {
        NumberFormatConfig config = Aurora.getLibConfig().getNumberFormat();
        this.intFormats.put(Locale.ROOT, new NumberFormat(config.getLocale(), config.getIntFormat()));
        this.doubleFormats.put(Locale.ROOT, new NumberFormat(config.getLocale(), config.getDoubleFormat()));
        this.shortFormats.put(Locale.ROOT, new NumberFormat(config.getLocale(), config.getShortNumberFormat().getFormat()));
    }

    @Override
    public boolean canHook() {
        return true;
    }

    public String formatWholeNumber(long number) {
        return this.formatWholeNumber(Locale.ROOT, number);
    }

    public String formatDecimalNumber(double number) {
        return this.formatDecimalNumber(Locale.ROOT, number);
    }

    public String formatNumberShort(double number) {
        return this.formatNumberShort(Locale.ROOT, number);
    }

    public String formatNumberShort(Locale locale, double number) {
        return this.formatWithSuffix(locale, number);
    }

    public String formatWholeNumber(Locale locale, long number) {
        if (this.intFormats.containsKey(locale)) {
            return this.intFormats.get(locale).format(number);
        }
        NumberFormatConfig config = Aurora.getLibConfig().getNumberFormat();
        NumberFormat formatter = new NumberFormat(locale.toLanguageTag(), config.getIntFormat());
        this.intFormats.put(locale, formatter);
        return formatter.format(number);
    }

    public String formatDecimalNumber(Locale locale, double number) {
        if (this.doubleFormats.containsKey(locale)) {
            return this.doubleFormats.get(locale).format(number);
        }
        NumberFormatConfig config = Aurora.getLibConfig().getNumberFormat();
        NumberFormat formatter = new NumberFormat(locale.toLanguageTag(), config.getDoubleFormat());
        this.doubleFormats.put(locale, formatter);
        return formatter.format(number);
    }

    private String formatWithSuffix(Locale locale, double number) {
        NumberFormat shortFormat;
        Map<String, String> suffixes = Aurora.getLibConfig().getNumberFormat().getShortNumberFormat().getSuffixes();
        if (this.shortFormats.containsKey(locale)) {
            shortFormat = this.shortFormats.get(locale);
        } else {
            NumberFormatConfig config = Aurora.getLibConfig().getNumberFormat();
            NumberFormat formatter = new NumberFormat(locale.toLanguageTag(), config.getShortNumberFormat().getFormat());
            this.shortFormats.put(locale, formatter);
            shortFormat = formatter;
        }
        if (number < 1000.0) {
            return shortFormat.format(number);
        }
        if (number < 1000000.0) {
            return shortFormat.format(number / 1000.0) + suffixes.get("thousand");
        }
        if (number < 1.0E9) {
            return shortFormat.format(number / 1000000.0) + suffixes.get("million");
        }
        if (number < 1.0E12) {
            return shortFormat.format(number / 1.0E9) + suffixes.get("billion");
        }
        if (number < 1.0E15) {
            return shortFormat.format(number / 1.0E12) + suffixes.get("trillion");
        }
        return shortFormat.format(number / 1.0E15) + suffixes.get("quadrillion");
    }

    public Map<Locale, NumberFormat> getIntFormats() {
        return this.intFormats;
    }

    public Map<Locale, NumberFormat> getDoubleFormats() {
        return this.doubleFormats;
    }

    public Map<Locale, NumberFormat> getShortFormats() {
        return this.shortFormats;
    }
}

