/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.aurora.expansions.worldguard;

import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.handler.Handler;
import gg.auroramc.aurora.api.dependency.Dep;
import gg.auroramc.aurora.api.dependency.DependencyManager;
import gg.auroramc.aurora.api.events.region.PlayerRegionEnterEvent;
import gg.auroramc.aurora.api.events.region.PlayerRegionLeaveEvent;
import gg.auroramc.aurora.api.expansions.AuroraExpansion;
import gg.auroramc.aurora.expansions.worldguard.WorldGuardEntryAndLeaveHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class WorldGuardExpansion
implements AuroraExpansion,
Listener {
    private final Map<UUID, Set<ProtectedRegion>> previousRegions = new HashMap<UUID, Set<ProtectedRegion>>();
    private final Map<UUID, Location> teleportMoves = new HashMap<UUID, Location>();

    protected void onRegionUpdate(UUID playerUUID, Set<ProtectedRegion> newRegions) {
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player == null) {
            return;
        }
        Set<ProtectedRegion> oldRegions = this.previousRegions.get(playerUUID);
        ArrayList<ProtectedRegion> regions = new ArrayList<ProtectedRegion>(newRegions);
        if (regions.isEmpty()) {
            if (oldRegions != null && !oldRegions.isEmpty()) {
                this.previousRegions.remove(playerUUID);
                Bukkit.getPluginManager().callEvent((Event)new PlayerRegionLeaveEvent(player, oldRegions.stream().toList()));
            }
            return;
        }
        List<ProtectedRegion> enterRegions = newRegions.stream().filter(r -> oldRegions == null || !oldRegions.contains(r)).toList();
        List<ProtectedRegion> leaveRegions = oldRegions == null ? null : oldRegions.stream().filter(r -> !newRegions.contains(r)).toList();
        this.previousRegions.put(playerUUID, newRegions);
        if (leaveRegions != null && !leaveRegions.isEmpty()) {
            Bukkit.getPluginManager().callEvent((Event)new PlayerRegionLeaveEvent(player, leaveRegions));
        }
        if (!enterRegions.isEmpty()) {
            Bukkit.getPluginManager().callEvent((Event)new PlayerRegionEnterEvent(player, enterRegions));
        }
    }

    protected void addTeleportMove(UUID playerUUID, Location location) {
        this.teleportMoves.put(playerUUID, location);
    }

    protected void removeTeleportMove(UUID playerUUID) {
        this.teleportMoves.remove(playerUUID);
    }

    protected boolean checkFreeMoveAfterTeleport(UUID playerUUID, Location location) {
        if (this.teleportMoves.containsKey(playerUUID)) {
            Location oldLocation = this.teleportMoves.get(playerUUID);
            this.removeTeleportMove(playerUUID);
            if (oldLocation == null) {
                return false;
            }
            if (oldLocation.getWorld() != location.getWorld()) {
                return false;
            }
            return oldLocation.distance(location) <= 5.0;
        }
        return false;
    }

    @Override
    public void hook() {
        WorldGuardEntryAndLeaveHandler.Factory handler = WorldGuardEntryAndLeaveHandler.FACTORY(this);
        WorldGuard.getInstance().getPlatform().getSessionManager().registerHandler((Handler.Factory)handler, null);
    }

    @Override
    public boolean canHook() {
        return DependencyManager.hasDep(Dep.WORLDGUARD);
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent e) {
        this.previousRegions.remove(e.getPlayer().getUniqueId());
        this.teleportMoves.remove(e.getPlayer().getUniqueId());
    }
}

