/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.commonraven.mob.goals;

import aquariusplayz.animalgarden.commonraven.Registrations;
import aquariusplayz.animalgarden.commonraven.mob.ModMob;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class ModItemGoal
extends Goal {
    protected final ModMob mob;
    private double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private long lastCanUseCheck;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;

    public ModItemGoal(ModMob p_25552_, double p_25553_, boolean p_25554_) {
        this.mob = p_25552_;
        this.speedModifier = p_25553_;
        this.followingTargetEvenIfNotSeen = p_25554_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.mob.m_21033_(EquipmentSlot.MAINHAND) || this.mob.dropItemOffAt != null || this.mob.itemFoundCooldown > 0) {
            return false;
        }
        if (this.mob.m_21824_() && this.mob.getBehaviorType() == 4) {
            return false;
        }
        long i = this.mob.m_9236_().m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        ItemEntity livingentity = this.mob.nearestItemEntity;
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.ticksUntilNextPathRecalculation <= 0) {
                this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
        return this.path != null ? true : this.mob.isWithinMeleeAttackRange((Entity)livingentity);
    }

    public boolean m_8045_() {
        ItemEntity livingentity = this.mob.nearestItemEntity;
        if (this.mob.m_21033_(EquipmentSlot.MAINHAND) && this.mob.itemFoundCooldown > 0) {
            return false;
        }
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.m_21573_().m_26571_();
        }
        return this.mob.m_21444_(livingentity.m_20183_());
    }

    public void m_8056_() {
        ItemEntity livingentity = this.mob.nearestItemEntity;
        this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
        this.mob.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        ItemEntity livingentity = this.mob.nearestItemEntity;
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.mob.m_6710_(null);
        }
        this.mob.m_21561_(false);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        ItemEntity livingentity = this.mob.nearestItemEntity;
        if (livingentity != null && !this.mob.m_21033_(EquipmentSlot.MAINHAND)) {
            this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                this.pathedTargetX = livingentity.m_20185_();
                this.pathedTargetY = livingentity.m_20186_();
                this.pathedTargetZ = livingentity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                double d0 = this.mob.m_20280_((Entity)livingentity);
                if (this.canPenalize) {
                    Node finalPathPoint;
                    this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack((Entity)livingentity);
        }
    }

    protected void checkAndPerformAttack(Entity p_25557_) {
        if (this.canPerformAttack(p_25557_) && this.mob.nearestItemEntity != null && this.mob.itemFoundCooldown == 0) {
            this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)4);
            this.mob.m_8061_(EquipmentSlot.MAINHAND, this.mob.nearestItemEntity.m_32055_().m_41777_());
            this.mob.m_9236_().m_245803_((Entity)this.mob, this.mob.m_20183_(), SoundEvents.f_12019_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.mob.nearestItemEntity.m_146870_();
            this.mob.nearestItemEntity = null;
            this.mob.randomItemDropCooldown = this.mob.m_217043_().m_188503_(2400) + 1200;
            this.mob.itemFoundCooldown = 200;
            this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)24);
            this.mob.m_5496_((SoundEvent)Registrations.IDLE4.get(), 2.0f, this.mob.m_217043_().m_188501_() * 0.4f + 0.8f);
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.m_183277_(20);
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean canPerformAttack(Entity p_301160_) {
        return this.isTimeToAttack() && this.mob.isWithinMeleeAttackRange(p_301160_) && this.mob.m_21574_().m_148306_(p_301160_);
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.m_183277_(20);
    }
}

