/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.commonraven.mob.goals;

import aquariusplayz.animalgarden.commonraven.mob.ModMob;
import aquariusplayz.animalgarden.commonraven.mob.goals.ModTargetingConditions;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class ModNearestItemTargetGoal<T extends ItemEntity>
extends TargetGoal {
    protected final Class<T> targetType;
    protected final int randomInterval;
    protected Entity target;
    protected ModTargetingConditions targetConditions;
    protected final ModMob mob;

    public ModNearestItemTargetGoal(ModMob p_26060_, Class<T> p_26061_, boolean p_26062_) {
        this(p_26060_, p_26061_, 10, p_26062_, false, null);
    }

    public ModNearestItemTargetGoal(ModMob p_199891_, Class<T> p_199892_, boolean p_199893_, ModTargetingConditions.Selector p_365854_) {
        this(p_199891_, p_199892_, 10, p_199893_, false, p_365854_);
    }

    public ModNearestItemTargetGoal(ModMob p_26064_, Class<T> p_26065_, boolean p_26066_, boolean p_26067_) {
        this(p_26064_, p_26065_, 10, p_26066_, p_26067_, null);
    }

    public ModNearestItemTargetGoal(ModMob p_26053_, Class<T> p_26054_, int p_26055_, boolean p_26056_, boolean p_26057_, ModTargetingConditions.Selector p_365081_) {
        super((Mob)p_26053_, p_26056_, p_26057_);
        this.mob = p_26053_;
        this.targetType = p_26054_;
        this.randomInterval = ModNearestItemTargetGoal.m_186073_((int)p_26055_);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.targetConditions = ModTargetingConditions.forCombat().range(this.m_7623_()).selector(p_365081_);
    }

    public boolean m_8036_() {
        if (this.mob.m_21033_(EquipmentSlot.MAINHAND) || this.mob.dropItemOffAt != null || this.mob.itemFoundCooldown > 0) {
            return false;
        }
        if (this.mob.m_21824_() && this.mob.getBehaviorType() == 4) {
            return false;
        }
        if (this.randomInterval > 0 && this.mob.m_217043_().m_188503_(this.randomInterval) != 0) {
            return false;
        }
        this.findTarget();
        return this.target != null;
    }

    protected AABB getTargetSearchArea(double p_26069_) {
        return this.mob.m_20191_().m_82377_(p_26069_, p_26069_, p_26069_);
    }

    protected void findTarget() {
        int a;
        T target = this.getNearestEntity(this.mob.m_9236_().m_6443_(this.targetType, this.getTargetSearchArea(this.m_7623_()), p_148152_ -> true), this.getTargetConditions(), (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_());
        this.target = target;
        int x = a = 2;
        int y = a;
        int z = a;
        BlockPos pos = null;
        BlockState state = null;
        for (int i = -x; i < x && pos == null; ++i) {
            block1: for (int j = -y; j < y && pos == null; ++j) {
                for (int k = -z; k < z; ++k) {
                    state = this.mob.m_9236_().m_8055_(this.mob.m_20183_().m_7918_(i, j, k));
                    if (state == null || !state.m_60713_(Blocks.f_50332_)) continue;
                    pos = this.mob.m_20183_().m_7918_(i, j, k);
                    continue block1;
                }
            }
        }
        if (pos != null && pos.m_203198_(this.mob.m_20182_().f_82479_, this.mob.m_20182_().f_82480_, this.mob.m_20182_().f_82481_) < 10.0) {
            this.target = null;
            return;
        }
    }

    public <T extends ItemEntity> T getNearestEntity(List<? extends T> p_363565_, ModTargetingConditions p_366923_, LivingEntity mob, double p_366460_, double p_364508_, double p_364611_) {
        double d0 = -1.0;
        ItemEntity t = null;
        for (ItemEntity t1 : p_363565_) {
            if (!this.test((ServerLevel)mob.m_9236_(), mob, (Entity)t1)) continue;
            double d1 = t1.m_20275_(p_366460_, p_364508_, p_364611_);
            if (d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            t = t1;
        }
        return (T)t;
    }

    public boolean canAttack(LivingEntity p_21171_) {
        return p_21171_ instanceof Player && p_21171_.m_9236_().m_46791_() == Difficulty.PEACEFUL ? false : this.canBeSeenAsEnemy((Entity)p_21171_);
    }

    public boolean canBeSeenAsEnemy(Entity p_21171_) {
        return !p_21171_.m_20147_() && this.canBeSeenByAnyone(p_21171_);
    }

    public boolean canBeSeenByAnyone(Entity p_21171_) {
        return !p_21171_.m_5833_() && p_21171_.m_6084_();
    }

    public double getVisibilityPercent(Entity p_20969_, LivingEntity p_26886_) {
        double d0 = 1.0;
        if (p_26886_.m_20163_()) {
            d0 *= 0.8;
        }
        if (p_26886_.m_20145_()) {
            float f = p_26886_.m_21207_();
            if (f < 0.1f) {
                f = 0.1f;
            }
            d0 *= 0.7 * (double)f;
        }
        if (p_20969_ != null) {
            ItemStack itemstack = p_26886_.m_6844_(EquipmentSlot.HEAD);
            EntityType entitytype = p_20969_.m_6095_();
            if (entitytype == EntityType.f_20524_ && itemstack.m_150930_(Items.f_42678_) || entitytype == EntityType.f_20501_ && itemstack.m_150930_(Items.f_42681_) || entitytype == EntityType.f_20511_ && itemstack.m_150930_(Items.f_260451_) || entitytype == EntityType.f_20512_ && itemstack.m_150930_(Items.f_260451_) || entitytype == EntityType.f_20558_ && itemstack.m_150930_(Items.f_42682_)) {
                d0 *= 0.5;
            }
        }
        return d0;
    }

    public boolean test(ServerLevel p_364974_, LivingEntity p_26886_, Entity p_26887_) {
        if (p_26886_ == p_26887_) {
            return false;
        }
        if (p_26887_.m_5833_() || !p_26887_.m_6084_()) {
            return false;
        }
        if (this.targetConditions.selector != null && !this.targetConditions.selector.test(p_26887_, p_364974_)) {
            return false;
        }
        if (p_26886_ == null) {
            if (this.targetConditions.isCombat && (p_26887_.m_20147_() || p_26887_.m_5833_() || !p_26887_.m_6084_() || p_364974_.m_46791_() == Difficulty.PEACEFUL)) {
                return false;
            }
        } else {
            Mob mob;
            if (this.targetConditions.isCombat && (!this.canBeSeenAsEnemy(p_26887_) || !p_26886_.m_6549_(p_26887_.m_6095_()) || p_26886_.m_7307_(p_26887_))) {
                return false;
            }
            if (this.targetConditions.range > 0.0) {
                double d0 = this.targetConditions.testInvisible ? this.getVisibilityPercent(p_26887_, p_26886_) : 1.0;
                double d1 = Math.max(this.targetConditions.range * d0, 2.0);
                double d2 = p_26886_.m_20275_(p_26887_.m_20185_(), p_26887_.m_20186_(), p_26887_.m_20189_());
                if (d2 > d1 * d1) {
                    return false;
                }
            }
            if (this.targetConditions.checkLineOfSight && p_26886_ instanceof Mob && !(mob = (Mob)p_26886_).m_21574_().m_148306_(p_26887_)) {
                return false;
            }
        }
        return true;
    }

    public void m_8056_() {
        this.mob.setItemEntityTarget(this.target);
        super.m_8056_();
    }

    public void setTarget(LivingEntity p_26071_) {
        this.target = p_26071_;
    }

    private ModTargetingConditions getTargetConditions() {
        return this.targetConditions.range(this.m_7623_());
    }
}

