/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.commonraven.mob.goals;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;

public class ModTargetingConditions {
    public static final ModTargetingConditions DEFAULT = ModTargetingConditions.forCombat();
    public final boolean isCombat;
    public double range = -1.0;
    public boolean checkLineOfSight = true;
    public boolean testInvisible = true;
    public Selector selector;

    private ModTargetingConditions(boolean p_148351_) {
        this.isCombat = p_148351_;
    }

    public static ModTargetingConditions forCombat() {
        return new ModTargetingConditions(true);
    }

    public static ModTargetingConditions forNonCombat() {
        return new ModTargetingConditions(false);
    }

    public ModTargetingConditions copy() {
        ModTargetingConditions targetingconditions = this.isCombat ? ModTargetingConditions.forCombat() : ModTargetingConditions.forNonCombat();
        targetingconditions.range = this.range;
        targetingconditions.checkLineOfSight = this.checkLineOfSight;
        targetingconditions.testInvisible = this.testInvisible;
        targetingconditions.selector = this.selector;
        return targetingconditions;
    }

    public ModTargetingConditions range(double p_26884_) {
        this.range = p_26884_;
        return this;
    }

    public ModTargetingConditions ignoreLineOfSight() {
        this.checkLineOfSight = false;
        return this;
    }

    public ModTargetingConditions ignoreInvisibilityTesting() {
        this.testInvisible = false;
        return this;
    }

    public ModTargetingConditions selector(Selector p_362620_) {
        this.selector = p_362620_;
        return this;
    }

    public boolean test(ServerLevel p_364974_, Entity p_26886_, LivingEntity p_26887_) {
        if (p_26886_ == p_26887_) {
            return false;
        }
        if (!p_26887_.m_142065_()) {
            return false;
        }
        if (this.selector != null && !this.selector.test((Entity)p_26887_, p_364974_)) {
            return false;
        }
        if (p_26886_ == null) {
            if (this.isCombat && (!p_26887_.m_142066_() || p_364974_.m_46791_() == Difficulty.PEACEFUL)) {
                return false;
            }
        } else {
            ItemEntity entity;
            if (p_26886_ instanceof LivingEntity) {
                Mob mob;
                LivingEntity entity2 = (LivingEntity)p_26886_;
                if (this.isCombat && (!entity2.m_6779_(p_26887_) || !entity2.m_6549_(p_26887_.m_6095_()) || entity2.m_7307_((Entity)p_26887_))) {
                    return false;
                }
                if (this.range > 0.0) {
                    double d0 = this.testInvisible ? p_26887_.m_20968_((Entity)entity2) : 1.0;
                    double d1 = Math.max(this.range * d0, 2.0);
                    double d2 = entity2.m_20275_(p_26887_.m_20185_(), p_26887_.m_20186_(), p_26887_.m_20189_());
                    if (d2 > d1 * d1) {
                        return false;
                    }
                }
                return !this.checkLineOfSight || !(p_26886_ instanceof Mob) || (mob = (Mob)p_26886_).m_21574_().m_148306_((Entity)p_26887_);
            }
            if (p_26886_ instanceof ItemEntity && (entity = (ItemEntity)p_26886_) != null) {
                Mob mob;
                if (this.range > 0.0) {
                    double d0 = this.testInvisible ? p_26887_.m_20968_((Entity)entity) : 1.0;
                    double d1 = Math.max(this.range * d0, 2.0);
                    double d2 = entity.m_20275_(p_26887_.m_20185_(), p_26887_.m_20186_(), p_26887_.m_20189_());
                    if (d2 > d1 * d1) {
                        return false;
                    }
                }
                if (this.checkLineOfSight && p_26887_ instanceof Mob && !(mob = (Mob)p_26887_).m_21574_().m_148306_((Entity)entity)) {
                    return false;
                }
            }
        }
        return true;
    }

    @FunctionalInterface
    public static interface Selector {
        public boolean test(Entity var1, ServerLevel var2);
    }
}

