/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.commonraven.mob;

import aquariusplayz.animalgarden.commonraven.mob.MobAnimations;
import aquariusplayz.animalgarden.commonraven.mob.ModMob;
import aquariusplayz.animalgarden.commonraven.mob.ModMobRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import org.joml.Vector3f;

public class ModMobModel
extends EntityModel<ModMobRenderState>
implements HeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.tryBuild((String)"animalgarden_commonraven", (String)"mob"), "main");
    public static final ModelLayerLocation BABY_LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.tryBuild((String)"animalgarden_commonraven", (String)"mob_baby"), "main");
    public static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(Set.of("head"));
    private final ModelPart rootz;
    private final ModelPart head;
    private final ModelPart upperBeak;
    private final ModelPart bottomBeak;
    private final ModelPart rightEye;
    private final ModelPart rightEyeball;
    private final ModelPart leftEye;
    private final ModelPart leftEyeball;
    private final ModelPart body;
    private final ModelPart chest;
    private final ModelPart tail;
    private final ModelPart rightLeg;
    private final ModelPart rightLegFinger4;
    private final ModelPart rightLegFinger1;
    private final ModelPart rightLegFinger3;
    private final ModelPart rightLegFinger2;
    private final ModelPart leftLeg;
    private final ModelPart leftLegFinger4;
    private final ModelPart leftLegFinger1;
    private final ModelPart leftLegFinger3;
    private final ModelPart leftLegFinger2;
    private final ModelPart wingRight;
    private final ModelPart wingRight2;
    private final ModelPart wingRight3;
    private final ModelPart wingLeft;
    private final ModelPart wingLeft2;
    private final ModelPart wingLeft3;
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public ModMobModel(ModelPart root) {
        super(root);
        this.rootz = root.getChild("rootz");
        this.head = this.rootz.getChild("head");
        this.upperBeak = this.head.getChild("upperBeak");
        this.bottomBeak = this.head.getChild("bottomBeak");
        this.rightEye = this.head.getChild("rightEye");
        this.rightEyeball = this.rightEye.getChild("rightEyeball");
        this.leftEye = this.head.getChild("leftEye");
        this.leftEyeball = this.leftEye.getChild("leftEyeball");
        this.body = this.rootz.getChild("body");
        this.chest = this.body.getChild("chest");
        this.tail = this.body.getChild("tail");
        this.rightLeg = this.body.getChild("rightLeg");
        this.rightLegFinger4 = this.rightLeg.getChild("rightLegFinger4");
        this.rightLegFinger1 = this.rightLeg.getChild("rightLegFinger1");
        this.rightLegFinger3 = this.rightLeg.getChild("rightLegFinger3");
        this.rightLegFinger2 = this.rightLeg.getChild("rightLegFinger2");
        this.leftLeg = this.body.getChild("leftLeg");
        this.leftLegFinger4 = this.leftLeg.getChild("leftLegFinger4");
        this.leftLegFinger1 = this.leftLeg.getChild("leftLegFinger1");
        this.leftLegFinger3 = this.leftLeg.getChild("leftLegFinger3");
        this.leftLegFinger2 = this.leftLeg.getChild("leftLegFinger2");
        this.wingRight = this.body.getChild("wingRight");
        this.wingRight2 = this.wingRight.getChild("wingRight2");
        this.wingRight3 = this.wingRight2.getChild("wingRight3");
        this.wingLeft = this.body.getChild("wingLeft");
        this.wingLeft2 = this.wingLeft.getChild("wingLeft2");
        this.wingLeft3 = this.wingLeft2.getChild("wingLeft3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition rootz = partdefinition.addOrReplaceChild("rootz", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)21.25f, (float)0.0f));
        PartDefinition head = rootz.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 27).addBox(-2.5f, -8.0f, -2.0f, 5.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(36, 41).addBox(-2.5f, -7.0f, 2.0f, 5.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.25f, (float)-0.5f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition upperBeak = head.addOrReplaceChild("upperBeak", CubeListBuilder.create().texOffs(13, 44).addBox(-1.0f, -1.9457f, -4.288f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(44, 51).addBox(-1.0f, -2.0957f, -2.288f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.15f)), PartPose.offset((float)0.0f, (float)-4.7543f, (float)-1.462f));
        PartDefinition bottomBeak = head.addOrReplaceChild("bottomBeak", CubeListBuilder.create().texOffs(44, 13).addBox(-1.0f, 0.2991f, -4.2411f, 2.0f, 1.0f, 4.0f, new CubeDeformation(-0.15f)).texOffs(52, 4).addBox(-0.5f, 0.4491f, -1.8911f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)0.0f, (float)-5.1491f, (float)-1.5089f));
        PartDefinition rightEye = head.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(25, 54).addBox(-0.45f, -0.9925f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)-2.07f, (float)-6.0175f, (float)-1.02f));
        PartDefinition rightEyeball = rightEye.addOrReplaceChild("rightEyeball", CubeListBuilder.create().texOffs(26, 44).addBox(-1.0f, -0.775f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.6f)).texOffs(26, 49).addBox(-1.0f, -1.225f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.6f)), PartPose.offset((float)-0.05f, (float)-0.0075f, (float)-0.25f));
        PartDefinition leftEye = head.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(55, 19).addBox(-0.55f, -0.9925f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)2.07f, (float)-6.0175f, (float)-1.02f));
        PartDefinition leftEyeball = leftEye.addOrReplaceChild("leftEyeball", CubeListBuilder.create().texOffs(49, 31).addBox(-1.0f, -0.775f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.6f)).texOffs(49, 36).addBox(-1.0f, -1.225f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.6f)), PartPose.offset((float)0.05f, (float)-0.0075f, (float)-0.25f));
        PartDefinition body = rootz.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-6.5978f, (float)-1.5088f));
        PartDefinition chest = body.addOrReplaceChild("chest", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = chest.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(33, 0).addBox(-3.5f, -3.0f, 7.0f, 7.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(33, 8).addBox(-3.5f, -3.0f, 9.0f, 7.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-3.5f, -3.0f, -2.0f, 7.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.5978f, (float)1.5088f, (float)-0.5672f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -1.0f, 0.0f, 5.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(52, 0).addBox(-1.5f, -1.0f, 8.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.9978f, (float)10.5088f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = body.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(44, 19).addBox(-1.0f, -1.0f, -1.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)-1.75f, (float)5.3478f, (float)3.5088f, (float)0.0f, (float)0.2182f, (float)0.0f));
        PartDefinition cube_r2 = rightLeg.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(32, 55).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition rightLegFinger4 = rightLeg.addOrReplaceChild("rightLegFinger4", CubeListBuilder.create().texOffs(37, 55).addBox(-6.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)6.0f, (float)3.6f, (float)-0.45f));
        PartDefinition rightLegFinger1 = rightLeg.addOrReplaceChild("rightLegFinger1", CubeListBuilder.create(), PartPose.offset((float)5.1589f, (float)3.65f, (float)-0.8907f));
        PartDefinition cube_r3 = rightLegFinger1.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(49, 41).addBox(-0.2836f, -0.5f, -2.4763f, 1.0f, 1.0f, 3.0f, new CubeDeformation(-0.15f)), PartPose.offsetAndRotation((float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.0f));
        PartDefinition rightLegFinger3 = rightLeg.addOrReplaceChild("rightLegFinger3", CubeListBuilder.create(), PartPose.offset((float)6.8411f, (float)3.65f, (float)-0.8907f));
        PartDefinition cube_r4 = rightLegFinger3.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(49, 46).addBox(-0.7164f, -0.5f, -2.4763f, 1.0f, 1.0f, 3.0f, new CubeDeformation(-0.15f)), PartPose.offsetAndRotation((float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f));
        PartDefinition rightLegFinger2 = rightLeg.addOrReplaceChild("rightLegFinger2", CubeListBuilder.create().texOffs(50, 8).addBox(-6.5f, -0.5f, -2.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(-0.15f)), PartPose.offset((float)6.0f, (float)3.65f, (float)-0.95f));
        PartDefinition leftLeg = body.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(49, 25).addBox(-1.0f, -1.0f, -1.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)1.75f, (float)5.3478f, (float)3.5088f, (float)0.0f, (float)-0.2182f, (float)0.0f));
        PartDefinition cube_r5 = leftLeg.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(44, 55).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0257f, (float)1.0f, (float)0.0084f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition leftLegFinger4 = leftLeg.addOrReplaceChild("leftLegFinger4", CubeListBuilder.create().texOffs(0, 56).addBox(-6.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)5.9743f, (float)3.6f, (float)-0.4416f));
        PartDefinition leftLegFinger1 = leftLeg.addOrReplaceChild("leftLegFinger1", CubeListBuilder.create(), PartPose.offset((float)5.1332f, (float)3.65f, (float)-0.8823f));
        PartDefinition cube_r6 = leftLegFinger1.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(35, 50).addBox(-0.2836f, -0.5f, -2.4763f, 1.0f, 1.0f, 3.0f, new CubeDeformation(-0.15f)), PartPose.offsetAndRotation((float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.0f));
        PartDefinition leftLegFinger3 = leftLeg.addOrReplaceChild("leftLegFinger3", CubeListBuilder.create(), PartPose.offset((float)6.8154f, (float)3.65f, (float)-0.8823f));
        PartDefinition cube_r7 = leftLegFinger3.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(0, 51).addBox(-0.7164f, -0.5f, -2.4763f, 1.0f, 1.0f, 3.0f, new CubeDeformation(-0.15f)), PartPose.offsetAndRotation((float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f));
        PartDefinition leftLegFinger2 = leftLeg.addOrReplaceChild("leftLegFinger2", CubeListBuilder.create().texOffs(9, 51).addBox(-6.5f, -0.5f, -2.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(-0.15f)), PartPose.offset((float)5.9743f, (float)3.65f, (float)-0.9416f));
        PartDefinition wingRight = body.addOrReplaceChild("wingRight", CubeListBuilder.create().texOffs(27, 16).addBox(-0.5f, -3.0f, -1.0f, 1.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)0.5978f, (float)2.7588f, (float)-0.4363f, (float)0.1309f, (float)0.1745f));
        PartDefinition wingRight2 = wingRight.addOrReplaceChild("wingRight2", CubeListBuilder.create().texOffs(36, 30).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)6.0f));
        PartDefinition wingRight3 = wingRight2.addOrReplaceChild("wingRight3", CubeListBuilder.create().texOffs(18, 51).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)5.0f));
        PartDefinition wingLeft = body.addOrReplaceChild("wingLeft", CubeListBuilder.create().texOffs(19, 30).addBox(-0.5f, -3.0f, -1.0f, 1.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)0.5978f, (float)2.7588f, (float)-0.4363f, (float)-0.1309f, (float)-0.1745f));
        PartDefinition wingLeft2 = wingLeft.addOrReplaceChild("wingLeft2", CubeListBuilder.create().texOffs(0, 40).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)6.0f));
        PartDefinition wingLeft3 = wingLeft2.addOrReplaceChild("wingLeft3", CubeListBuilder.create().texOffs(53, 51).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)5.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(ModMobRenderState p_368486_) {
        super.setupAnim((EntityRenderState)p_368486_);
        ModMob mob = p_368486_.entity;
        this.animate(mob.wink, MobAnimations.wink, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.lookUp, MobAnimations.lookUp, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.lookDown, MobAnimations.lookDown, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.lookBack, MobAnimations.lookBack, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.lookForward, MobAnimations.lookForward, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.breathing, MobAnimations.breathing, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.peck, MobAnimations.peck, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.gularFluttering, MobAnimations.gularFluttering, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.sitDown, MobAnimations.sitDown, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.sitting, MobAnimations.sitting, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.headUp, MobAnimations.headUp, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.headDown, MobAnimations.headDown, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.headLeft, MobAnimations.headLeft, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.headRight, MobAnimations.headRight, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.headTiltLeft, MobAnimations.headTiltLeft, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.headTiltRight, MobAnimations.headTiltRight, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.headMoreUp, MobAnimations.headMoreUp, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.headMoreDown, MobAnimations.headMoreDown, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.headMoreLeft, MobAnimations.headMoreLeft, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.headMoreRight, MobAnimations.headMoreRight, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.headTiltMoreLeft, MobAnimations.headTiltMoreLeft, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.headTiltMoreRight, MobAnimations.headTiltMoreRight, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.eat, MobAnimations.eat, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.idleSound1, MobAnimations.idleSound1, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.idleSound2, MobAnimations.idleSound2, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.idleSound3, MobAnimations.idleSound3, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.idleSound4, MobAnimations.idleSound4, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.idleSound5, MobAnimations.idleSound5, p_368486_.ageInTicks, 1.0f);
        if (mob.flyingAnimation) {
            this.animateWalk(MobAnimations.flying, p_368486_.walkAnimationPos, p_368486_.walkAnimationSpeed, p_368486_.isBaby ? 2.0f : 8.0f, 25.0f);
        } else {
            this.animateWalk(MobAnimations.walking, p_368486_.walkAnimationPos, p_368486_.walkAnimationSpeed, p_368486_.isBaby ? 2.5f : 5.0f, 25.0f);
        }
    }

    public void translateToHead(PoseStack poseStack) {
        this.root.translateAndRotate(poseStack);
        this.rootz.translateAndRotate(poseStack);
        this.head.translateAndRotate(poseStack);
    }

    protected void animate(AnimationState p_361867_, AnimationDefinition p_365477_, float p_361961_) {
        this.animate(p_361867_, p_365477_, p_361961_, 1.0f);
    }

    protected void animateWalk(AnimationDefinition p_363127_, float p_364817_, float p_364163_, float p_365350_, float p_365167_) {
        long i = (long)(p_364817_ * 50.0f * p_365350_);
        float f = Math.min(p_364163_ * p_365167_, 1.0f);
        ModMobModel.animate((Model)this, p_363127_, i, f, ANIMATION_VECTOR_CACHE);
    }

    protected void animate(AnimationState p_368871_, AnimationDefinition p_365491_, float p_363110_, float p_368202_) {
        p_368871_.ifStarted(p_368242_ -> ModMobModel.animate((Model)this, p_365491_, (long)((float)p_368242_.getTimeInMillis(p_363110_) * p_368202_), 1.0f, ANIMATION_VECTOR_CACHE));
    }

    protected void applyStatic(AnimationDefinition p_369884_) {
        ModMobModel.animate((Model)this, p_369884_, 0L, 1.0f, ANIMATION_VECTOR_CACHE);
    }

    public static Optional<ModelPart> getAnyDescendantWithName(Model p_362391_, String p_363872_) {
        Stream stream = p_362391_.root().getAllParts().toList().stream();
        return p_363872_.equals("root") ? Optional.of(p_362391_.root()) : stream.filter(p_364767_ -> p_364767_.hasChild(p_363872_)).findFirst().map(p_366385_ -> p_366385_.getChild(p_363872_));
    }

    public static void animate(Model p_362391_, AnimationDefinition p_232321_, long p_232322_, float p_232323_, Vector3f p_253861_) {
        float f = ModMobModel.getElapsedSeconds(p_232321_, p_232322_);
        for (Map.Entry entry : p_232321_.boneAnimations().entrySet()) {
            Optional<ModelPart> optional = ModMobModel.getAnyDescendantWithName(p_362391_, (String)entry.getKey());
            List list = (List)entry.getValue();
            optional.ifPresent(p_232330_ -> list.forEach(p_288241_ -> {
                Keyframe[] akeyframe = p_288241_.keyframes();
                int i = Math.max(0, Mth.binarySearch((int)0, (int)akeyframe.length, p_232315_ -> f <= akeyframe[p_232315_].timestamp()) - 1);
                int j = Math.min(akeyframe.length - 1, i + 1);
                Keyframe keyframe = akeyframe[i];
                Keyframe keyframe1 = akeyframe[j];
                float f1 = f - keyframe.timestamp();
                float f2 = j != i ? Mth.clamp((float)(f1 / (keyframe1.timestamp() - keyframe.timestamp())), (float)0.0f, (float)1.0f) : 0.0f;
                keyframe1.interpolation().apply(p_253861_, f2, akeyframe, i, j, p_232323_);
                p_288241_.target().apply(p_232330_, p_253861_);
            }));
        }
    }

    public static float getElapsedSeconds(AnimationDefinition p_232317_, long p_232318_) {
        float f = (float)p_232318_ / 1000.0f;
        return p_232317_.looping() ? f % p_232317_.lengthInSeconds() : f;
    }

    public ModelPart getHead() {
        return this.head;
    }
}

