/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.commonraven.mob.goals;

import aquariusplayz.animalgarden.commonraven.mob.ModMob;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class ModMobWanderFlyGoal
extends WaterAvoidingRandomStrollGoal {
    public final ModMob mob;
    public int startDistance = 10;
    public final float stopDistance = 2.0f;
    public int timeToRecalcPath;
    public float oldWaterCost;
    public Mob followingMob;
    public Predicate<Mob> followPredicate = p_25278_ -> p_25278_ != null && p_25278_.getClass() == Wolf.class;
    public float areaSize = 7.0f;

    public ModMobWanderFlyGoal(PathfinderMob p_186224_, double p_186225_) {
        super(p_186224_, p_186225_);
        this.mob = (ModMob)p_186224_;
    }

    public void start() {
        if (this.mob.getBehaviorType() != 4) {
            if (this.mob.isTame() && this.mob.getBehaviorType() == 6 || this.followingMob != null) {
                this.timeToRecalcPath = 0;
                this.oldWaterCost = this.mob.getPathfindingMalus(PathType.WATER);
                this.mob.setPathfindingMalus(PathType.WATER, 0.0f);
            } else {
                super.start();
            }
        }
    }

    public void stop() {
        if (this.mob.getBehaviorType() == 4) {
            super.stop();
        }
        if (this.mob.isTame() && this.mob.getBehaviorType() == 6 && this.mob.getOwner() != null || this.followingMob != null) {
            this.mob.getNavigation().stop();
            this.mob.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
        } else {
            super.stop();
        }
    }

    public void tick() {
        if (this.mob.getBehaviorType() == 4) {
            this.mob.getNavigation().stop();
        } else if (this.mob.isTame() && this.mob.getBehaviorType() == 6 && this.mob.getOwner() != null) {
            boolean flag = this.mob.shouldTryTeleportToOwner();
            if (!flag) {
                this.mob.getLookControl().setLookAt((Entity)this.mob.getOwner(), 10.0f, (float)this.mob.getMaxHeadXRot());
            }
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.adjustedTickDelay(10);
                if (flag) {
                    this.mob.getNavigation().moveTo((Entity)this.mob.getOwner(), 1.5);
                } else {
                    this.mob.getNavigation().moveTo((Entity)this.mob.getOwner(), this.speedModifier);
                }
            }
        } else if (this.followingMob != null) {
            Wolf wolf;
            Mob mob = this.followingMob;
            if (mob instanceof Wolf && (wolf = (Wolf)mob).getTarget() != null && this.mob.getTarget() == null) {
                this.mob.setTarget(wolf.getTarget());
            }
            if (this.followingMob != null && !this.mob.isLeashed()) {
                this.mob.getLookControl().setLookAt((Entity)this.followingMob, 10.0f, (float)this.mob.getMaxHeadXRot());
                if (--this.timeToRecalcPath <= 0) {
                    double d2;
                    double d1;
                    this.timeToRecalcPath = this.adjustedTickDelay(10);
                    double d0 = this.mob.getX() - this.followingMob.getX();
                    double d3 = d0 * d0 + (d1 = this.mob.getY() - this.followingMob.getY()) * d1 + (d2 = this.mob.getZ() - this.followingMob.getZ()) * d2;
                    if (!(d3 <= (double)(this.stopDistance * this.stopDistance))) {
                        this.mob.getNavigation().moveTo((Entity)this.followingMob, this.speedModifier);
                    } else {
                        this.mob.getNavigation().stop();
                        LookControl lookcontrol = this.followingMob.getLookControl();
                        Objects.requireNonNull(this);
                        if (d3 <= 2.0 || lookcontrol.getWantedX() == this.mob.getX() && lookcontrol.getWantedY() == this.mob.getY() && lookcontrol.getWantedZ() == this.mob.getZ()) {
                            double d4 = this.followingMob.getX() - this.mob.getX();
                            double d5 = this.followingMob.getZ() - this.mob.getZ();
                            this.mob.getNavigation().moveTo(this.mob.getX() - d4, this.mob.getY(), this.mob.getZ() - d5, this.speedModifier);
                        }
                    }
                }
            }
        } else {
            super.tick();
        }
    }

    public boolean canUse() {
        if (this.mob.getBehaviorType() == 4) {
            return true;
        }
        if (this.mob.dropItemOffAt != null || this.mob.getBehaviorType() == 4) {
            return false;
        }
        if (this.mob.isTame() && this.mob.getBehaviorType() == 6) {
            this.followingMob = null;
            LivingEntity livingentity = this.mob.getOwner();
            if (livingentity == null) {
                return false;
            }
            if (this.mob.unableToMoveToOwner()) {
                return false;
            }
            return !(this.mob.distanceToSqr((Entity)livingentity) < (double)(this.startDistance * this.startDistance));
        }
        if (this.mob.getBehaviorType() == 0) {
            Vec3 vec3;
            List list;
            if (!this.mob.isAggressive() && !(list = this.mob.level().getEntitiesOfClass(Wolf.class, this.mob.getBoundingBox().inflate((double)this.areaSize), this.followPredicate)).isEmpty()) {
                for (Wolf mob : list) {
                    if (mob.isInvisible()) continue;
                    this.followingMob = mob;
                    return true;
                }
            }
            if (this.mob.level().getBlockState(this.mob.blockPosition()).is(Blocks.WATER) && this.mob.getNavigation().isDone()) {
                this.mob.wantsToLand = false;
                vec3 = this.getFlyingFromWaterPosition();
                if (vec3 == null) {
                    return false;
                }
                this.wantedX = vec3.x;
                this.wantedY = vec3.y + 1.0;
                this.wantedZ = vec3.z;
                this.forceTrigger = false;
                return true;
            }
            if (this.mob.getNavigation().isDone() && (this.mob.isInWater() || this.mob.getRandom().nextInt(10) == 0)) {
                vec3 = this.getPosition();
                if (vec3 == null) {
                    return false;
                }
                this.wantedX = vec3.x;
                this.wantedY = vec3.y;
                this.wantedZ = vec3.z;
                this.forceTrigger = false;
                return true;
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.mob.getBehaviorType() == 4) {
            return true;
        }
        if (this.mob.isTame() && this.mob.getBehaviorType() == 6 && this.mob.getOwner() != null) {
            if (this.mob.getNavigation().isDone()) {
                return false;
            }
            return this.mob.unableToMoveToOwner() ? false : !(this.mob.distanceToSqr((Entity)this.mob.getOwner()) <= (double)(this.stopDistance * this.stopDistance));
        }
        if (this.mob.dropItemOffAt == null && !this.mob.isInLove() && this.followingMob != null && !this.mob.getNavigation().isDone() && this.mob.distanceToSqr((Entity)this.followingMob) > (double)(this.stopDistance * this.stopDistance)) {
            return true;
        }
        return super.canContinueToUse();
    }

    protected Vec3 getFlyingFromWaterPosition() {
        Vec3 vec3 = this.mob.getViewVector(0.0f);
        Vec3 vec31 = HoverRandomPos.getPos((PathfinderMob)this.mob, (int)8, (int)7, (double)vec3.x, (double)vec3.z, (float)1.5707964f, (int)3, (int)1);
        return vec31 != null ? vec31 : AirAndWaterRandomPos.getPos((PathfinderMob)this.mob, (int)40, (int)15, (int)-2, (double)vec3.x, (double)vec3.z, (double)1.5707963705062866);
    }

    protected Vec3 getFlyingPosition() {
        Vec3 vec3 = this.mob.getViewVector(0.0f);
        Vec3 vec31 = HoverRandomPos.getPos((PathfinderMob)this.mob, (int)8, (int)7, (double)vec3.x, (double)vec3.z, (float)1.5707964f, (int)3, (int)1);
        return vec31 != null ? vec31 : AirAndWaterRandomPos.getPos((PathfinderMob)this.mob, (int)40, (int)15, (int)-2, (double)vec3.x, (double)vec3.z, (double)1.5707963705062866);
    }

    protected Vec3 getPosition() {
        if (this.mob.isInWater()) {
            return this.getFlyingFromWaterPosition();
        }
        if (!this.mob.wantsToLand) {
            return this.getFlyingPosition();
        }
        return this.getGroundPosition();
    }

    protected Vec3 getGroundPosition() {
        Vec3 vec3 = null;
        if (this.mob.isInWater() || this.mob.isInLove() || this.mob.isAggressive()) {
            vec3 = LandRandomPos.getPos((PathfinderMob)this.mob, (int)15, (int)15);
        }
        if (this.mob.getRandom().nextFloat() >= this.probability) {
            vec3 = this.getNotAirPos();
        }
        return vec3 == null ? super.getPosition() : vec3;
    }

    private Vec3 getNotAirPos() {
        BlockPos blockpos = this.mob.blockPosition();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
        double x = 15.0;
        double y = 10.0;
        double z = 15.0;
        for (BlockPos blockpos1 : BlockPos.betweenClosed((int)Mth.floor((double)(this.mob.getX() - x)), (int)Mth.floor((double)(this.mob.getY() - y)), (int)Mth.floor((double)(this.mob.getZ() - z)), (int)Mth.floor((double)(this.mob.getX() + x)), (int)Mth.floor((double)(this.mob.getY() + y)), (int)Mth.floor((double)(this.mob.getZ() + z)))) {
            BlockState blockstate;
            if (blockpos.equals((Object)blockpos1) || (blockstate = this.mob.level().getBlockState((BlockPos)blockpos$mutableblockpos1.setWithOffset((Vec3i)blockpos1, Direction.DOWN))).isAir() || blockstate.is(Blocks.WATER) || !this.mob.level().isEmptyBlock(blockpos1) || !this.mob.level().isEmptyBlock((BlockPos)blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos1, Direction.UP))) continue;
            return Vec3.atBottomCenterOf((Vec3i)blockpos1);
        }
        return null;
    }
}

