/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.commonraven.mob;

import aquariusplayz.animalgarden.commonraven.Registrations;
import aquariusplayz.animalgarden.commonraven.mob.ModAnimationState;
import aquariusplayz.animalgarden.commonraven.mob.controls.ModBodyRotationControl;
import aquariusplayz.animalgarden.commonraven.mob.controls.ModFlyingMoveControl;
import aquariusplayz.animalgarden.commonraven.mob.controls.ModMoveControl;
import aquariusplayz.animalgarden.commonraven.mob.controls.ModSmoothSwimmingLookControl;
import aquariusplayz.animalgarden.commonraven.mob.controls.pathnavigation.ModFlyingPathNavigation;
import aquariusplayz.animalgarden.commonraven.mob.controls.pathnavigation.ModGroundPathNavigation;
import aquariusplayz.animalgarden.commonraven.mob.goals.ModBreedGoal;
import aquariusplayz.animalgarden.commonraven.mob.goals.ModDropItemOffNearPlayerGoal;
import aquariusplayz.animalgarden.commonraven.mob.goals.ModDropOffItemGoal;
import aquariusplayz.animalgarden.commonraven.mob.goals.ModItemGoal;
import aquariusplayz.animalgarden.commonraven.mob.goals.ModMeleeAttackGoal;
import aquariusplayz.animalgarden.commonraven.mob.goals.ModMobWanderFlyGoal;
import aquariusplayz.animalgarden.commonraven.mob.goals.ModNearestAttackableTargetGoal;
import aquariusplayz.animalgarden.commonraven.mob.goals.ModNearestItemTargetGoal;
import aquariusplayz.animalgarden.commonraven.mob.goals.ModOwnerHurtByTargetGoal;
import aquariusplayz.animalgarden.commonraven.mob.goals.ModOwnerHurtTargetGoal;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ModMob
extends TamableAnimal
implements NeutralMob,
FlyingAnimal {
    private static final EntityDataAccessor<Integer> BEHAVIOR = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> FEATHER_COLOR = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> EYE_COLOR = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;
    public final ModAnimationState wink = new ModAnimationState();
    public final ModAnimationState lookUp = new ModAnimationState();
    public final ModAnimationState lookDown = new ModAnimationState();
    public final ModAnimationState lookBack = new ModAnimationState();
    public final ModAnimationState lookForward = new ModAnimationState();
    public final ModAnimationState breathing = new ModAnimationState();
    public final ModAnimationState peck = new ModAnimationState();
    public final ModAnimationState gularFluttering = new ModAnimationState();
    public final ModAnimationState sitDown = new ModAnimationState();
    public final ModAnimationState sitting = new ModAnimationState();
    public final ModAnimationState headUp = new ModAnimationState();
    public final ModAnimationState headDown = new ModAnimationState();
    public final ModAnimationState headLeft = new ModAnimationState();
    public final ModAnimationState headRight = new ModAnimationState();
    public final ModAnimationState headTiltLeft = new ModAnimationState();
    public final ModAnimationState headTiltRight = new ModAnimationState();
    public final ModAnimationState headMoreUp = new ModAnimationState();
    public final ModAnimationState headMoreDown = new ModAnimationState();
    public final ModAnimationState headMoreLeft = new ModAnimationState();
    public final ModAnimationState headMoreRight = new ModAnimationState();
    public final ModAnimationState headTiltMoreLeft = new ModAnimationState();
    public final ModAnimationState headTiltMoreRight = new ModAnimationState();
    public final ModAnimationState eat = new ModAnimationState();
    public final ModAnimationState idleSound1 = new ModAnimationState();
    public final ModAnimationState idleSound2 = new ModAnimationState();
    public final ModAnimationState idleSound3 = new ModAnimationState();
    public final ModAnimationState idleSound4 = new ModAnimationState();
    public final ModAnimationState idleSound5 = new ModAnimationState();
    public boolean isRunning = false;
    public boolean wantsToLand = false;
    public int targetFoundCooldown;
    public ItemEntity nearestItemEntity;
    public int itemFoundCooldown;
    public BlockPos dropItemOffAt = null;
    public int randomItemDropCooldown;
    public boolean dropItemNow = false;
    public boolean flyingAnimation = false;

    public ModMob(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.setTame(false, false);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 4.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
        this.lookControl = new ModSmoothSwimmingLookControl((Mob)this, 10);
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    public void travel(Vec3 p_30218_) {
        if (this.getNavigation().isDone()) {
            this.moveRelative(0.1f, p_30218_);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.7).add(0.0, -0.01, 0.0));
            this.move(MoverType.SELF, this.getDeltaMovement());
        } else {
            super.travel(p_30218_);
        }
    }

    protected PathNavigation createNavigation(Level p_30171_) {
        if (this.onGround() && !this.isInWater()) {
            return new ModGroundPathNavigation((Mob)this, p_30171_);
        }
        return this.flyingPathNavigation(p_30171_);
    }

    public PathNavigation flyingPathNavigation(Level p_30171_) {
        ModFlyingPathNavigation flyingpathnavigation = new ModFlyingPathNavigation((Mob)this, p_30171_);
        flyingpathnavigation.setCanFloat(true);
        flyingpathnavigation.setCanOpenDoors(false);
        return flyingpathnavigation;
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_335317_) {
        super.defineSynchedData(p_335317_);
        p_335317_.define(BEHAVIOR, (Object)0);
        p_335317_.define(FEATHER_COLOR, (Object)0);
        p_335317_.define(EYE_COLOR, (Object)0);
        p_335317_.define(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public int getBehaviorType() {
        return (Integer)this.entityData.get(BEHAVIOR);
    }

    private void setBehaviorType(int p_30398_) {
        this.entityData.set(BEHAVIOR, (Object)p_30398_);
    }

    public int getEyeColor() {
        return (Integer)this.entityData.get(EYE_COLOR);
    }

    private void setEyeColor(int p_30398_) {
        this.entityData.set(EYE_COLOR, (Object)p_30398_);
    }

    public int getFeatherColor() {
        return (Integer)this.entityData.get(FEATHER_COLOR);
    }

    private void setFeatherColor(int p_30398_) {
        this.entityData.set(FEATHER_COLOR, (Object)p_30398_);
    }

    public void addAdditionalSaveData(ValueOutput p_29422_) {
        super.addAdditionalSaveData(p_29422_);
        this.addPersistentAngerSaveData(p_29422_);
        p_29422_.putInt("FeatherColor", this.getFeatherColor());
        p_29422_.putInt("EyeColor", this.getEyeColor());
        p_29422_.putInt("BehaviorType", this.getBehaviorType());
    }

    public void readAdditionalSaveData(ValueInput p_29402_) {
        super.readAdditionalSaveData(p_29402_);
        this.readPersistentAngerSaveData(this.level(), p_29402_);
        this.setFeatherColor(p_29402_.getIntOr("FeatherColor", 0));
        this.setEyeColor(p_29402_.getIntOr("EyeColor", 0));
        this.setBehaviorType(p_29402_.getIntOr("BehaviorType", 0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.FLYING_SPEED, 1.0).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.TEMPT_RANGE, 16.0).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public float getWalkTargetValue(BlockPos p_33895_, LevelReader p_33896_) {
        return 10.0f;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new ModBreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new ModDropOffItemGoal(this, 1.25));
        this.goalSelector.addGoal(4, (Goal)new ModDropItemOffNearPlayerGoal(this, 1.25, true));
        this.goalSelector.addGoal(6, (Goal)new ModMeleeAttackGoal(this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new ModItemGoal(this, 1.0, true));
        this.goalSelector.addGoal(10, (Goal)new ModMobWanderFlyGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new ModOwnerHurtByTargetGoal(this));
        this.targetSelector.addGoal(2, (Goal)new ModOwnerHurtTargetGoal(this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(5, new ModNearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, true, false, this::targetSelector));
        this.targetSelector.addGoal(6, new ModNearestItemTargetGoal<ItemEntity>(this, ItemEntity.class, 10, true, false, this::allowedItemEntity));
        this.targetSelector.addGoal(7, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public boolean isWithinMeleeAttackRange(Entity p_217067_) {
        return this.getAttackBoundingBox().inflate(1.0).intersects(this.getHitbox(p_217067_));
    }

    public boolean isWithinMeleeRange() {
        return this.getAttackBoundingBox().deflate(0.0).intersects(new AABB(this.dropItemOffAt.above()));
    }

    protected AABB getHitbox(Entity p_217067_) {
        AABB aabb = p_217067_.getBoundingBox();
        Entity entity = p_217067_.getVehicle();
        if (entity != null) {
            Vec3 vec3 = entity.getPassengerRidingPosition(p_217067_);
            return aabb.setMinY(Math.max(vec3.y, aabb.minY));
        }
        return aabb;
    }

    public boolean allowedItemEntity(Entity entity, ServerLevel p_366229_) {
        return entity.isAlive() && entity instanceof ItemEntity && !entity.isInWater();
    }

    public boolean targetSelector(LivingEntity p_21675_, ServerLevel p_366229_) {
        ModMob mob;
        if (this.isTame()) {
            ServerLevel level;
            if (p_21675_ == this.getOwner()) {
                return false;
            }
            Level level2 = this.level();
            if (level2 instanceof ServerLevel && !this.isAngryAt(p_21675_, level = (ServerLevel)level2)) {
                return false;
            }
            if (this.wantsToAttack(p_21675_, this.getOwner())) {
                return true;
            }
        } else if (p_21675_ instanceof ModMob && !(mob = (ModMob)p_21675_).isTame()) {
            return false;
        }
        if (!this.canAttack(p_21675_)) {
            return false;
        }
        return this.isAngryAt(p_21675_, p_366229_);
    }

    protected BodyRotationControl createBodyControl() {
        return new ModBodyRotationControl((Mob)this);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, EntitySpawnReason p_366700_, SpawnGroupData p_146749_) {
        if (this.getRandom().nextInt(100) <= 9) {
            this.setFeatherColor(this.getRandom().nextInt(2) + 3);
        } else {
            this.setFeatherColor(this.getRandom().nextInt(3));
        }
        if (this.getFeatherColor() >= 3) {
            this.setEyeColor(this.getRandom().nextInt(10));
        } else {
            this.setEyeColor(this.getRandom().nextInt(6));
        }
        return super.finalizeSpawn(p_146746_, p_146747_, p_366700_, p_146749_);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void defaultAnimations() {
        int i;
        if (!this.breathing.isStarted()) {
            this.breathing.start(this.tickCount);
        }
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.wink, 1.0f)) {
            this.wink.start(this.tickCount);
        }
        if (this.level().random.nextInt(200) == 0 && this.animationEnded(this.gularFluttering, 1.0f)) {
            this.gularFluttering.start(this.tickCount);
        }
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.eat, 1.25f) && this.animationEnded(this.headUp, 1.25f) && this.animationEnded(this.headDown, 1.25f) && this.animationEnded(this.headMoreUp, 1.5f) && this.animationEnded(this.headMoreDown, 2.0f) && this.animationEnded(this.headTiltLeft, 2.0f) && this.animationEnded(this.headTiltRight, 2.0f) && this.animationEnded(this.headTiltMoreLeft, 1.75f) && this.animationEnded(this.headTiltMoreRight, 1.75f)) {
            this.wink.start(this.tickCount);
        }
        if (this.level().random.nextInt(50) == 0 && this.animationEnded(this.lookUp, 2.0f) && this.animationEnded(this.lookDown, 2.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.lookUp.start(this.tickCount);
            } else {
                this.lookDown.start(this.tickCount);
            }
        }
        if (this.level().random.nextInt(50) == 0 && this.animationEnded(this.lookBack, 2.0f) && this.animationEnded(this.lookForward, 2.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.lookBack.start(this.tickCount);
            } else {
                this.lookForward.start(this.tickCount);
            }
        }
        if (this.level().random.nextInt(50) == 0 && this.animationEnded(this.eat, 1.25f) && this.animationEnded(this.headUp, 1.25f) && this.animationEnded(this.headDown, 1.25f) && this.animationEnded(this.headMoreUp, 1.5f) && this.animationEnded(this.headMoreDown, 2.0f)) {
            i = this.getRandom().nextInt(4);
            if (i == 0) {
                this.headUp.start(this.tickCount);
            } else if (i == 1) {
                this.headDown.start(this.tickCount);
            } else if (i == 2) {
                this.headMoreUp.start(this.tickCount);
            } else {
                this.headMoreDown.start(this.tickCount);
            }
        }
        if (this.level().random.nextInt(50) == 0 && this.animationEnded(this.headLeft, 1.25f) && this.animationEnded(this.headRight, 1.25f) && this.animationEnded(this.headMoreLeft, 2.0f) && this.animationEnded(this.headMoreRight, 2.0f)) {
            i = this.getRandom().nextInt(4);
            if (i == 0) {
                this.headLeft.start(this.tickCount);
            } else if (i == 1) {
                this.headRight.start(this.tickCount);
            } else if (i == 2) {
                this.headMoreLeft.start(this.tickCount);
            } else {
                this.headMoreRight.start(this.tickCount);
            }
        }
        if (this.level().random.nextInt(50) == 0 && this.animationEnded(this.eat, 1.25f) && this.animationEnded(this.headTiltLeft, 1.25f) && this.animationEnded(this.headTiltRight, 1.25f) && this.animationEnded(this.headTiltMoreLeft, 1.75f) && this.animationEnded(this.headTiltMoreRight, 1.75f)) {
            i = this.getRandom().nextInt(4);
            if (i == 0) {
                this.headTiltLeft.start(this.tickCount);
            } else if (i == 1) {
                this.headTiltRight.start(this.tickCount);
            } else if (i == 2) {
                this.headTiltMoreLeft.start(this.tickCount);
            } else {
                this.headTiltMoreRight.start(this.tickCount);
            }
        }
    }

    public void calculateEntityAnimation(boolean p_268129_) {
        float f = (float)Mth.length((double)(this.getX() - this.xo), (double)(p_268129_ ? this.getY() - this.yo : 0.0), (double)(this.getZ() - this.zo));
        if (!this.isPassenger() && this.isAlive()) {
            this.updateWalkAnimation(f);
        } else {
            this.walkAnimation.stop();
        }
    }

    public void updateWalkAnimation(float p_268283_) {
        float f = Math.min(p_268283_ * 4.0f, 1.0f);
        this.walkAnimation.update(f, 0.4f, this.isBaby() ? 3.0f : 1.0f);
    }

    protected int calculateFallDamage(double p_393496_, float p_21237_) {
        return 0;
    }

    public boolean causeFallDamage(double p_393354_, float p_147187_, DamageSource p_147189_) {
        return false;
    }

    protected void checkFallDamage(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
    }

    public void aiStep() {
        super.aiStep();
        if (this.onGround() && !this.walkAnimation.isMoving()) {
            this.flyingAnimation = false;
        } else if (!this.onGround() || !this.walkAnimation.isMoving()) {
            this.flyingAnimation = true;
        }
        if (this.level() instanceof ServerLevel) {
            if (!this.isAggressive()) {
                if (this.wantsToLand) {
                    if (this.random.nextInt(500) == 0) {
                        this.wantsToLand = false;
                    }
                } else if (this.random.nextInt(100) == 0) {
                    this.wantsToLand = true;
                }
            }
            if (this.wantsToLand && !this.isInWater()) {
                if (this.navigation instanceof ModFlyingPathNavigation && this.onGround()) {
                    this.navigation = new ModGroundPathNavigation((Mob)this, this.level());
                    this.moveControl = new ModMoveControl((Mob)this);
                }
            } else if (this.navigation instanceof ModGroundPathNavigation) {
                this.navigation = this.flyingPathNavigation(this.level());
                this.moveControl = new ModFlyingMoveControl((Mob)this, 10, false);
            }
        }
        if (this.targetFoundCooldown > 0) {
            --this.targetFoundCooldown;
        }
        if (this.itemFoundCooldown > 0) {
            --this.itemFoundCooldown;
        }
        if (this.randomItemDropCooldown > 0) {
            --this.randomItemDropCooldown;
        }
        if (this.level().isClientSide()) {
            if (this.getBehaviorType() == 4) {
                if (!this.sitting.isStarted() && !this.sitDown.isStarted()) {
                    this.sitDown.start(this.tickCount);
                } else if (!this.sitting.isStarted() && this.sitDown.isStarted() && this.animationEnded(this.sitDown, 0.5f)) {
                    this.sitting.start(this.tickCount);
                    this.sitDown.stop();
                }
            } else if (this.sitting.isStarted() || this.sitDown.isStarted()) {
                this.sitDown.stop();
                this.sitting.stop();
            }
            if (!this.isAggressive()) {
                this.defaultAnimations();
            }
        } else {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public boolean doHurtTarget(ServerLevel p_365421_, Entity p_21372_) {
        p_365421_.broadcastEntityEvent((Entity)this, (byte)4);
        this.wantsToLand = false;
        return super.doHurtTarget(p_365421_, p_21372_);
    }

    public boolean hurtServer(ServerLevel p_361743_, DamageSource p_361865_, float p_365677_) {
        if (super.hurtServer(p_361743_, p_361865_, p_365677_)) {
            this.wantsToLand = false;
            if (this.isTame() && (this.getBehaviorType() == 1 || this.getBehaviorType() == 4)) {
                this.setBehaviorType(6);
            }
            return true;
        }
        return false;
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int p_30404_) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    public boolean wantsToAttack(LivingEntity enemy, LivingEntity p_30390_) {
        TamableAnimal tamableanimal;
        AbstractHorse abstracthorse;
        if (enemy == null) {
            return false;
        }
        if (enemy instanceof Creeper || enemy instanceof Ghast || enemy instanceof ArmorStand) {
            return false;
        }
        if (enemy instanceof ModMob) {
            ModMob mob = (ModMob)enemy;
            return !mob.isTame() || mob.getOwner() != p_30390_;
        }
        if (enemy instanceof Player && this.isTame() && this.getOwner() == enemy) {
            return false;
        }
        if (enemy instanceof Player) {
            Player player1;
            Player player = (Player)enemy;
            if (p_30390_ instanceof Player && !(player1 = (Player)p_30390_).canHarmPlayer(player)) {
                return false;
            }
        }
        if (enemy instanceof AbstractHorse && (abstracthorse = (AbstractHorse)enemy).isTamed()) {
            return false;
        }
        return !(enemy instanceof TamableAnimal) || !(tamableanimal = (TamableAnimal)enemy).isTame();
    }

    @Nullable
    public SoundEvent getAmbientSound() {
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource p_29437_) {
        return (SoundEvent)Registrations.IDLE1.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)Registrations.IDLE1.get();
    }

    public boolean animationEnded(ModAnimationState state, float animLength) {
        return (float)state.getTimeInMillis(this.tickCount) > animLength * 1000.0f;
    }

    public AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(0.5);
    }

    public boolean isFood(ItemStack itemstack) {
        FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
        if (foodproperties != null) {
            return true;
        }
        return itemstack.is(Registrations.COMMON_RAVEN_FOOD_ITEMS);
    }

    protected float getSoundVolume() {
        return 0.25f;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_148993_, AgeableMob p_148994_) {
        ModMob mob = (ModMob)this.getType().create((Level)p_148993_, EntitySpawnReason.BREEDING);
        if (this.isTame()) {
            mob.setOwnerReference(this.getOwnerReference());
            mob.setTame(true, true);
        }
        return mob;
    }

    public void tryToTame(Player p_336244_) {
        if (this.random.nextInt(10) == 0) {
            this.setBehaviorType(4);
            this.tame(p_336244_);
            this.navigation.stop();
            this.setTarget(null);
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
    }

    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(16.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(4.0);
            this.setHealth(16.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(6.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(3.0);
        }
    }

    public InteractionResult mobInteract(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.getItemInHand(p_30413_);
        ItemStack itemstack1 = this.getItemInHand(InteractionHand.MAIN_HAND);
        if (this.isTame() && this.getOwner() == p_30412_) {
            if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                this.usePlayerItem(p_30412_, p_30413_, itemstack);
                FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                float f = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                this.heal(4.0f * f);
                if (this.level() instanceof ServerLevel) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)5);
                }
                return super.mobInteract(p_30412_, p_30413_);
            }
            if (!itemstack1.isEmpty() && p_30413_ == InteractionHand.MAIN_HAND && itemstack.isEmpty()) {
                this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                this.level().playSound((Entity)p_30412_, (Entity)this, SoundEvents.ITEM_PICKUP, SoundSource.NEUTRAL, 1.0f, 1.0f);
                if (this.level() instanceof ServerLevel) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)4);
                }
                p_30412_.addItem(itemstack1);
                return InteractionResult.SUCCESS;
            }
            if (this.isOwnedBy((LivingEntity)p_30412_) && (!itemstack1.isEmpty() && p_30413_ == InteractionHand.MAIN_HAND && !itemstack.isEmpty() || itemstack1.isEmpty())) {
                if (this.getBehaviorType() == 0) {
                    this.setBehaviorType(4);
                    if (this.level() instanceof ServerLevel) {
                        this.playSound((SoundEvent)Registrations.IDLE3.get(), 1.0f, this.getRandom().nextFloat() * 0.4f + 0.8f);
                        this.level().broadcastEntityEvent((Entity)this, (byte)23);
                    }
                } else if (this.getBehaviorType() == 4) {
                    this.setBehaviorType(6);
                    if (this.level() instanceof ServerLevel) {
                        this.playSound((SoundEvent)Registrations.IDLE2.get(), 1.0f, this.getRandom().nextFloat() * 0.4f + 0.8f);
                        this.level().broadcastEntityEvent((Entity)this, (byte)22);
                    }
                } else {
                    this.setBehaviorType(0);
                    if (this.level() instanceof ServerLevel) {
                        this.playSound((SoundEvent)Registrations.IDLE1.get(), 1.0f, this.getRandom().nextFloat() * 0.4f + 0.8f);
                        this.level().broadcastEntityEvent((Entity)this, (byte)9);
                    }
                }
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null);
                return InteractionResult.SUCCESS;
            }
            return super.mobInteract(p_30412_, p_30413_);
        }
        if (!this.level().isClientSide() && this.isFood(itemstack)) {
            itemstack.consume(1, (LivingEntity)p_30412_);
            this.tryToTame(p_30412_);
            return InteractionResult.SUCCESS;
        }
        if (!this.level().isClientSide() && !itemstack1.isEmpty() && p_30413_ == InteractionHand.MAIN_HAND && itemstack.isEmpty()) {
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            this.level().playSound((Entity)p_30412_, (Entity)this, SoundEvents.ITEM_PICKUP, SoundSource.NEUTRAL, 1.0f, 1.0f);
            if (this.level() instanceof ServerLevel) {
                this.level().broadcastEntityEvent((Entity)this, (byte)4);
            }
            this.dropItemOffAt = null;
            this.nearestItemEntity = null;
            this.itemFoundCooldown = 40;
            this.dropItemNow = false;
            p_30412_.addItem(itemstack1);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(p_30412_, p_30413_);
    }

    public void handleEntityEvent(byte p_28844_) {
        if (p_28844_ == 4) {
            if (this.animationEnded(this.peck, 0.75f)) {
                this.peck.start(this.tickCount);
            }
        } else if (p_28844_ == 5) {
            if (this.animationEnded(this.eat, 1.25f)) {
                this.eat.start(this.tickCount);
            }
        } else if (p_28844_ == 9) {
            if (this.animationEnded(this.idleSound1, 1.25f)) {
                this.idleSound1.start(this.tickCount);
            }
        } else if (p_28844_ == 22) {
            if (this.animationEnded(this.idleSound2, 1.75f)) {
                this.idleSound2.start(this.tickCount);
            }
        } else if (p_28844_ == 23) {
            if (this.animationEnded(this.idleSound3, 2.5f)) {
                this.idleSound3.start(this.tickCount);
            }
        } else if (p_28844_ == 24) {
            if (this.animationEnded(this.idleSound4, 1.75f)) {
                this.idleSound4.start(this.tickCount);
            }
            this.itemFoundCooldown = 200;
        } else if (p_28844_ == 25) {
            if (this.animationEnded(this.idleSound5, 1.75f)) {
                this.idleSound5.start(this.tickCount);
            }
            this.targetFoundCooldown = 300;
        } else if (p_28844_ == 11) {
            this.isRunning = true;
        } else if (p_28844_ == 12) {
            this.isRunning = false;
        } else {
            super.handleEntityEvent(p_28844_);
        }
    }

    @Nullable
    public void setItemEntityTarget(Entity p_21544_) {
        if (p_21544_ != null && p_21544_ instanceof ItemEntity) {
            this.nearestItemEntity = (ItemEntity)p_21544_;
        }
    }

    protected void dropEquipment(ServerLevel p_362296_) {
        super.dropEquipment(p_362296_);
        ItemStack itemstack = this.getItemBySlot(EquipmentSlot.MAINHAND);
        if (!itemstack.isEmpty() && !EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) {
            this.spawnAtLocation(p_362296_, itemstack);
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    public boolean requiresCustomPersistence() {
        return true;
    }
}

