/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.commonraven.mob.goals;

import aquariusplayz.animalgarden.commonraven.mob.ModMob;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class ModDropOffItemGoal
extends Goal {
    protected final ModMob mob;
    private double speedModifier;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;
    private long lastCanUseCheck;

    public ModDropOffItemGoal(ModMob p_25552_, double p_25553_) {
        this.mob = p_25552_;
        this.speedModifier = p_25553_;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.mob.hasItemInSlot(EquipmentSlot.MAINHAND)) {
            if (this.mob.isTame() && this.mob.getBehaviorType() == 6) {
                return false;
            }
            if (this.mob.dropItemOffAt == null) {
                int a;
                int x = a = 10;
                int y = a;
                int z = a;
                BlockPos pos = this.mob.blockPosition();
                BlockState state = null;
                for (int i = -x; i < x && this.mob.dropItemOffAt == null; ++i) {
                    block1: for (int j = -y; j < y && this.mob.dropItemOffAt == null; ++j) {
                        for (int k = -z; k < z; ++k) {
                            state = this.mob.level().getBlockState(pos.offset(i, j, k));
                            if (state == null || !state.is(Blocks.HOPPER)) continue;
                            this.mob.dropItemOffAt = pos.offset(i, j, k);
                            continue block1;
                        }
                    }
                }
            }
            if (this.mob.dropItemOffAt != null) {
                long i = this.mob.level().getGameTime();
                if (i - this.lastCanUseCheck < 20L) {
                    return false;
                }
                this.lastCanUseCheck = i;
                if (this.canPenalize) {
                    if (--this.ticksUntilNextPathRecalculation <= 0) {
                        this.path = this.mob.getNavigation().createPath(this.mob.dropItemOffAt.getCenter().x, this.mob.dropItemOffAt.getCenter().y, this.mob.dropItemOffAt.getCenter().z, 0);
                        this.ticksUntilNextPathRecalculation = 4 + this.mob.getRandom().nextInt(7);
                        return this.path != null;
                    }
                    return true;
                }
                this.path = this.mob.getNavigation().createPath(this.mob.dropItemOffAt.getCenter().x, this.mob.dropItemOffAt.getCenter().y, this.mob.dropItemOffAt.getCenter().z, 0);
                return this.path != null ? true : this.mob.isWithinMeleeRange();
            }
            if (this.mob.randomItemDropCooldown == 0) {
                this.mob.dropItemNow = true;
                return true;
            }
        }
        return false;
    }

    public void start() {
        this.mob.getNavigation().moveTo(this.path, this.speedModifier);
        this.mob.setAggressive(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void tick() {
        if (!this.mob.isTame() || this.mob.getBehaviorType() != 6) {
            if (this.mob.dropItemNow && this.mob.dropItemOffAt == null && this.mob.getItemBySlot(EquipmentSlot.MAINHAND) != null) {
                ItemStack itemstack = this.mob.getItemBySlot(EquipmentSlot.MAINHAND);
                this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)4);
                this.mob.spawnAtLocation(itemstack.copy());
                this.mob.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                this.mob.level().playSound((Entity)this.mob, this.mob.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.mob.dropItemOffAt = null;
                this.mob.nearestItemEntity = null;
                this.mob.dropItemNow = false;
            } else if (this.mob.hasItemInSlot(EquipmentSlot.MAINHAND) && this.mob.dropItemOffAt != null) {
                this.mob.getLookControl().setLookAt(this.mob.dropItemOffAt.getCenter());
                this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                if (this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || this.mob.dropItemOffAt.distToCenterSqr(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.getRandom().nextFloat() < 0.05f)) {
                    this.pathedTargetX = this.mob.dropItemOffAt.getCenter().x();
                    this.pathedTargetY = this.mob.dropItemOffAt.getCenter().y();
                    this.pathedTargetZ = this.mob.dropItemOffAt.getCenter().z();
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.getRandom().nextInt(7);
                    double d0 = this.mob.distanceToSqr(this.mob.dropItemOffAt.getCenter());
                    if (this.canPenalize) {
                        Node finalPathPoint;
                        this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                        this.failedPathFindingPenalty = this.mob.getNavigation().getPath() != null ? ((finalPathPoint = this.mob.getNavigation().getPath().getEndNode()) != null && this.mob.dropItemOffAt.distToCenterSqr((double)finalPathPoint.x, (double)finalPathPoint.y, (double)finalPathPoint.z) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                    }
                    if (d0 > 1024.0) {
                        this.ticksUntilNextPathRecalculation += 10;
                    } else if (d0 > 256.0) {
                        this.ticksUntilNextPathRecalculation += 5;
                    }
                    if (!this.mob.getNavigation().moveTo(this.mob.dropItemOffAt.getCenter().x, this.mob.dropItemOffAt.getCenter().y, this.mob.dropItemOffAt.getCenter().z, this.speedModifier)) {
                        this.ticksUntilNextPathRecalculation += 15;
                    }
                    this.ticksUntilNextPathRecalculation = this.adjustedTickDelay(this.ticksUntilNextPathRecalculation);
                }
                this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
                this.checkAndPerformAttack(this.mob.dropItemOffAt.getCenter());
            }
        }
    }

    protected void checkAndPerformAttack(Vec3 p_25557_) {
        if (this.canPerformAttack(p_25557_) && this.mob.hasItemInSlot(EquipmentSlot.MAINHAND)) {
            ItemStack itemstack = this.mob.getItemBySlot(EquipmentSlot.MAINHAND);
            this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)4);
            this.mob.spawnAtLocation(itemstack.copy(), 1.0f);
            this.mob.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            this.mob.level().playSound((Entity)this.mob, this.mob.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.mob.dropItemOffAt = null;
            this.mob.nearestItemEntity = null;
            this.mob.itemFoundCooldown = 200;
            this.mob.dropItemNow = false;
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(20);
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean canPerformAttack(Vec3 p_301160_) {
        return this.isTimeToAttack() && this.mob.isWithinMeleeRange();
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.adjustedTickDelay(20);
    }
}

