package me.alexdevs.classicPeripherals.datagen.generators;

import dan200.computercraft.api.ComputerCraftAPI;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.block.ModBlocks;
import me.alexdevs.classicPeripherals.block.NfcReaderBlock;
import me.alexdevs.classicPeripherals.block.RfidScannerBlock;
import me.alexdevs.classicPeripherals.item.ModItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.data.models.blockstates.*;
import net.minecraft.data.models.model.*;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

import static net.minecraft.class_4941.method_25841;
import static net.minecraft.class_4944.method_25863;

public class ModelGenerator extends FabricModelProvider {
    private static final class_4942 RFID_SCANNER_MODEL = new class_4942(
            Optional.of(new class_2960(ClassicPeripherals.MOD_ID, "block/rfid_scanner_base")),
            Optional.empty(),
            class_4945.field_23010
    );

    private static final class_4942 TURTLE_UPGRADE_LEFT = new class_4942(
            Optional.of(new class_2960(ComputerCraftAPI.MOD_ID, "block/turtle_upgrade_base_left")),
            Optional.of("_left"),
            class_4945.field_23011
    );
    private static final class_4942 TURTLE_UPGRADE_RIGHT = new class_4942(
            Optional.of(new class_2960(ComputerCraftAPI.MOD_ID, "block/turtle_upgrade_base_right")),
            Optional.of("_left"),
            class_4945.field_23011
    );

    public ModelGenerator(FabricDataOutput output) {
        super(output);
    }

    @Override
    public void generateBlockStateModels(class_4910 generators) {
        generators.method_25623(ModBlocks.TOWER_BASE, method_25842(ModBlocks.TOWER_BASE));
        generators.method_25623(ModBlocks.TOWER_SEGMENT, method_25842(ModBlocks.TOWER_SEGMENT));
        generators.method_25623(ModBlocks.TOWER_HEAD, method_25843(ModBlocks.TOWER_HEAD, "_off"));
        generators.method_25623(ModBlocks.ANTENNA, method_25843(ModBlocks.ANTENNA, "_off"));

        createNfcReaderModel(generators, ModBlocks.NFC_READER);
        createRfidScannerModel(generators, ModBlocks.RFID_SCANNER);

        registerTurtleUpgrade(generators, "block/turtle_radio", "block/turtle_radio_face");
    }

    @Override
    public void generateItemModels(class_4915 generators) {
        generators.method_25733(ModItems.COPPER_COIL, class_4943.field_22938);
        generators.method_25733(ModItems.NFC_CARD, class_4943.field_22938);

        generateTwoLayeredItem(generators, ModItems.RFID_BADGE, "_color");
    }

    private void generateTwoLayeredItem(class_4915 generators, class_1792 item, String secondLayerSuffix) {
        class_4943.field_42232.method_25852(
                class_4941.method_25840(item),
                class_4944.method_48529(method_25876(item), method_25863(item, secondLayerSuffix)),
                generators.field_22844);
    }

    private void createNfcReaderModel(class_4910 generators, NfcReaderBlock block) {
        generators.field_22830.accept(class_4925.method_25769(block)
                .method_25775(class_4910.method_25599())
                .method_25775(createModelDispatch(NfcReaderBlock.STATE, value -> {
                    var suffix = "_front" + switch (value) {
                        case NONE -> "";
                        case READING -> "_reading";
                        case WRITING -> "_writing";
                    };

                    return class_4943.field_22978.method_25847(
                            block, "_" + value.method_15434(),
                            class_4944.method_25907(block).method_25868(class_4945.field_23016, class_4944.method_25866(block, suffix)),
                            generators.field_22831
                    );
                }))
        );

        generators.method_25623(block, method_25843(block, "_none"));
    }

    private void createRfidScannerModel(class_4910 generators, RfidScannerBlock block) {
        generators.field_22830.accept(class_4925.method_25769(block)
                .method_25775(class_4910.method_25640())
                .method_25775(createModelDispatch(RfidScannerBlock.ACTIVE, value -> {
                    var suffix = value ? "_on" : "";

                    return RFID_SCANNER_MODEL.method_25852(
                            method_25843(block, suffix),
                            new class_4944().method_25868(class_4945.field_23010, class_4944.method_25866(block, suffix)),
                            generators.field_22831
                    );
                })));

        generators.method_25623(block, method_25842(block));
    }

    private static void registerTurtleUpgrade(class_4910 generators, String name, String texture) {
        TURTLE_UPGRADE_LEFT.method_25852(
                new class_2960(ClassicPeripherals.MOD_ID, name + "_left"),
                class_4944.method_25869(new class_2960(ClassicPeripherals.MOD_ID, texture)),
                generators.field_22831
        );
        TURTLE_UPGRADE_RIGHT.method_25852(
                new class_2960(ClassicPeripherals.MOD_ID, name + "_right"),
                class_4944.method_25869(new class_2960(ClassicPeripherals.MOD_ID, texture)),
                generators.field_22831
        );
    }

    private static <T extends Comparable<T>> class_4926 createModelDispatch(class_2769<T> property, Function<T, class_2960> makeModel) {
        var variant = class_4926.method_25783(property);
        for (var value : property.method_11898()) {
            variant.method_25793(value, class_4935.method_25824().method_25828(class_4936.field_22887, makeModel.apply(value)));
        }
        return variant;
    }

    private static <T extends Comparable<T>, U extends Comparable<U>> class_4926 createModelDispatch(
            class_2769<T> propertyT, class_2769<U> propertyU, BiFunction<T, U, class_2960> makeModel
    ) {
        var variant = class_4926.method_25784(propertyT, propertyU);
        for (var valueT : propertyT.method_11898()) {
            for (var valueU : propertyU.method_11898()) {
                variant.method_25797(valueT, valueU, class_4935.method_25824().method_25828(class_4936.field_22887, makeModel.apply(valueT, valueU)));
            }
        }
        return variant;
    }
}
