/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.peripherals;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.AttachedComputerSet;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import me.alexdevs.classicPeripherals.core.TowerNetwork;
import me.alexdevs.classicPeripherals.tiles.AbstractRadioBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import oshi.annotation.concurrent.GuardedBy;

public abstract class AbstractRadioPeripheral
implements IPeripheral {
    @GuardedBy(value="computers")
    private final AttachedComputerSet computers = new AttachedComputerSet();
    private int channel = 0;
    protected final Random random = new Random();

    public String getType() {
        return "radio_tower";
    }

    public void attach(IComputerAccess computer) {
        this.computers.add(computer);
        TowerNetwork.addReceiver(this);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
        if (!this.computers.hasComputers()) {
            TowerNetwork.removeReceiver(this);
        }
    }

    public abstract boolean isValid();

    public abstract Level getLevel();

    public abstract Vec3 getPosition();

    public abstract double getRange();

    public abstract void ping();

    public abstract boolean canBroadcast();

    public int getHeight() {
        return 1;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public String flipString(String data, double percentage) {
        byte[] bytes = data.getBytes(StandardCharsets.US_ASCII);
        int total = bytes.length * 8;
        int toFlip = (int)Math.ceil((double)total * percentage);
        for (int i = 0; i < toFlip; ++i) {
            int bit = this.random.nextInt(total);
            int byteIndex = bit / 8;
            int bitIndex = bit % 8;
            int n = byteIndex;
            bytes[n] = (byte)(bytes[n] ^ (byte)(1 << bitIndex));
        }
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(String data, double distance, double range) {
        if (!this.isValid()) {
            return;
        }
        double safeRange = AbstractRadioBlockEntity.getSafeRange(range);
        if (distance > safeRange) {
            double unsafeRange = range - safeRange;
            double distanceInUnsafe = distance - safeRange;
            double corruption = distanceInUnsafe / unsafeRange;
            data = this.flipString(data, corruption);
        }
        String mutatedData = data;
        AttachedComputerSet attachedComputerSet = this.computers;
        synchronized (attachedComputerSet) {
            this.computers.forEach(computer -> computer.queueEvent("radio_message", new Object[]{computer.getAttachmentName(), mutatedData, distance}));
        }
        this.ping();
    }

    @LuaFunction(value={"isValid"})
    public final boolean LuaIsValid() {
        return this.isValid();
    }

    @LuaFunction(value={"broadcast"})
    public final void LuaBroadcast(String data) throws LuaException {
        if (!this.isValid()) {
            throw new LuaException("The radio tower is not built correctly.");
        }
        if (!this.canBroadcast()) {
            throw new LuaException("This antenna is not capable of broadcasting.");
        }
        TowerNetwork.broadcast(this, data, this.getRange());
        this.ping();
    }

    @LuaFunction(value={"canBroadcast"})
    public final boolean LuaCanBroadcast() {
        return this.canBroadcast();
    }

    @LuaFunction(mainThread=true, value={"setFrequency"})
    public final void LuaSetFrequency(ILuaContext context, int frequency) throws LuaException {
        if (frequency < 0 || frequency > 65535) {
            throw new LuaException("Frequency out of range. Must be between 0 and 65535.");
        }
        if (!this.isValid()) {
            throw new LuaException("The radio tower is not built correctly.");
        }
        int channel = TowerNetwork.getChannel(frequency);
        this.setChannel(channel);
    }

    @LuaFunction(value={"getFrequency"})
    public final int LuaGetFrequency() throws LuaException {
        if (!this.isValid()) {
            throw new LuaException("The radio tower is not built correctly.");
        }
        int channel = this.getChannel();
        return TowerNetwork.getFrequency(channel);
    }

    @LuaFunction(value={"getHeight"})
    public final int LuaGetHeight() throws LuaException {
        if (!this.isValid()) {
            throw new LuaException("The radio tower is not built correctly.");
        }
        return this.getHeight();
    }
}

