/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.recipe;

import dan200.computercraft.shared.util.ColourTracker;
import me.alexdevs.classicPeripherals.ModComponents;
import me.alexdevs.classicPeripherals.item.ModItems;
import me.alexdevs.classicPeripherals.recipe.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RfidBadgeRecipe
extends CustomRecipe {
    public RfidBadgeRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput container, Level level) {
        boolean hasItem = false;
        ColourTracker tracker = new ColourTracker();
        for (int i = 0; i < container.size(); ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is(ModItems.RFID_BADGE)) {
                hasItem = true;
                continue;
            }
            Item item = stack.getItem();
            if (!(item instanceof DyeItem)) continue;
            DyeItem dye = (DyeItem)item;
            tracker.addColour(dye.getDyeColor());
        }
        return hasItem && tracker.hasColour();
    }

    @NotNull
    public ItemStack assemble(CraftingInput container, HolderLookup.Provider registries) {
        ItemStack item = null;
        ColourTracker tracker = new ColourTracker();
        for (int i = 0; i < container.size(); ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is(ModItems.RFID_BADGE)) {
                item = stack.copy();
                item.setCount(1);
                DataComponentMap tag = item.getComponents();
                if (!tag.has((DataComponentType)ModComponents.NFC_COLOR.get())) continue;
                int value = (Integer)tag.getOrDefault((DataComponentType)ModComponents.NFC_COLOR.get(), (Object)0xFFFFFF);
                int r = value >> 16 & 0xFF;
                int g = value >> 8 & 0xFF;
                int b = value & 0xFF;
                tracker.addColour(r, g, b);
                continue;
            }
            Item item2 = stack.getItem();
            if (!(item2 instanceof DyeItem)) continue;
            DyeItem dye = (DyeItem)item2;
            tracker.addColour(dye.getDyeColor());
        }
        if (item != null && tracker.hasColour()) {
            item.applyComponents(DataComponentMap.builder().set(ModComponents.NFC_COLOR, (Object)tracker.getColour()).build());
            return item;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.RFID_BADGE_RECIPE.get();
    }
}

