/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.tiles;

import java.util.Optional;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.ModComponents;
import me.alexdevs.classicPeripherals.block.ModBlocks;
import me.alexdevs.classicPeripherals.block.NfcReaderBlock;
import me.alexdevs.classicPeripherals.item.NfcCardItem;
import me.alexdevs.classicPeripherals.peripherals.NfcReaderPeripheral;
import me.alexdevs.classicPeripherals.tiles.ModBlockTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;

public class NfcReaderBlockEntity
extends BlockEntity {
    protected final NfcReaderPeripheral peripheral = new NfcReaderPeripheral(this);
    private boolean writeMode = false;
    private String pendingWriteData = "";
    private @Nullable String pendingLabel = null;
    private boolean pendingReadOnly = false;

    public NfcReaderBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockTiles.NFC_READER.get(), pos, blockState);
    }

    public NfcReaderPeripheral peripheral() {
        return this.peripheral;
    }

    public void flagWrite(String data, @Nullable String label, Boolean flagReadOnly) {
        int maxDataSize = ClassicPeripherals.CONFIG.nfcMaxDataSize;
        this.writeMode = true;
        this.pendingWriteData = data.substring(0, Math.min(data.length(), maxDataSize));
        this.pendingLabel = label;
        this.pendingReadOnly = flagReadOnly;
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue(NfcReaderBlock.STATE, (Comparable)((Object)NfcReaderBlock.NfcReaderState.WRITING)));
    }

    public void cancelWrite() {
        this.writeMode = false;
        this.pendingWriteData = "";
        this.pendingLabel = null;
        this.pendingReadOnly = false;
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue(NfcReaderBlock.STATE, (Comparable)((Object)NfcReaderBlock.NfcReaderState.NONE)));
    }

    public boolean isWriteMode() {
        return this.writeMode;
    }

    public void pingRead() {
        this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue(NfcReaderBlock.STATE, (Comparable)((Object)NfcReaderBlock.NfcReaderState.READING)));
        this.level.scheduleTick(this.getBlockPos(), (Block)ModBlocks.NFC_READER.get(), 10);
    }

    public void onUse(ItemStack stack) {
        if (this.writeMode) {
            DataComponentMap components = stack.getComponents();
            Boolean readOnly = (Boolean)components.getOrDefault((DataComponentType)ModComponents.NFC_READONLY.get(), (Object)false);
            if (readOnly.booleanValue()) {
                this.peripheral.writeFeedback(false, "read_only");
                this.cancelWrite();
                return;
            }
            DataComponentMap.Builder mapBuilder = DataComponentMap.builder();
            if (this.pendingLabel != null) {
                mapBuilder.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.pendingLabel));
            } else {
                stack.remove(DataComponents.CUSTOM_NAME);
            }
            mapBuilder.set(ModComponents.NFC_DATA, (Object)this.pendingWriteData);
            mapBuilder.set(ModComponents.NFC_READONLY, (Object)this.pendingReadOnly);
            stack.applyComponents(mapBuilder.build());
            this.peripheral.writeFeedback(true, "success");
            this.cancelWrite();
        } else {
            Optional<String> data = NfcCardItem.getData(stack);
            if (data.isPresent()) {
                this.peripheral.read(data.get());
                this.pingRead();
            }
        }
    }
}

