/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.tiles;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.block.ModBlocks;
import me.alexdevs.classicPeripherals.block.RfidScannerBlock;
import me.alexdevs.classicPeripherals.item.ModItems;
import me.alexdevs.classicPeripherals.item.NfcCardItem;
import me.alexdevs.classicPeripherals.peripherals.RfidScannerPeripheral;
import me.alexdevs.classicPeripherals.tiles.ModBlockTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RfidScannerBlockEntity
extends BlockEntity {
    protected final RfidScannerPeripheral peripheral = new RfidScannerPeripheral(this);

    public RfidScannerBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockTiles.RFID_SCANNER.get(), pos, blockState);
    }

    @Nullable
    public RfidScannerPeripheral peripheral(@Nullable Direction direction) {
        return direction == null || this.getDirection() == direction ? this.peripheral : null;
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING);
    }

    public void scheduleScan() {
        this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)RfidScannerBlock.ACTIVE, (Comparable)Boolean.valueOf(true)));
        this.level.scheduleTick(this.getBlockPos(), (Block)ModBlocks.RFID_SCANNER.get(), 2);
    }

    public void scan() {
        List<ScannedRfidBadge> badges = this.scanBadges();
        this.peripheral.emitScanEvent(badges);
    }

    private List<ScannedRfidBadge> scanBadges() {
        ArrayList<ScannedRfidBadge> badges = new ArrayList<ScannedRfidBadge>();
        Level level = this.getLevel();
        Vec3 origin = this.peripheral.getPosition();
        if (level.isClientSide) {
            return List.of();
        }
        int range = ClassicPeripherals.CONFIG.rfidScanRange;
        List<ServerPlayer> nearbyPlayers = level.players().stream().filter(player -> player.position().distanceToSqr(origin) <= (double)(range * range)).map(player -> (ServerPlayer)player).toList();
        for (ServerPlayer player2 : nearbyPlayers) {
            Inventory inventory = player2.getInventory();
            for (ItemStack stack : inventory.items) {
                Optional<String> data;
                if (!stack.is(ModItems.RFID_BADGE) || (data = NfcCardItem.getData(stack)).isEmpty()) continue;
                badges.add(new ScannedRfidBadge(data.get(), player2.position().distanceTo(origin)));
            }
        }
        return badges;
    }

    public record ScannedRfidBadge(String data, double distance) {
    }
}

