package me.alexdevs.classicPeripherals.tiles;

import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.block.ModBlocks;
import me.alexdevs.classicPeripherals.block.NfcReaderBlock;
import me.alexdevs.classicPeripherals.item.NfcCardItem;
import me.alexdevs.classicPeripherals.peripherals.NfcReaderPeripheral;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jspecify.annotations.Nullable;

public class NfcReaderBlockEntity extends class_2586 {
    protected final NfcReaderPeripheral peripheral = new NfcReaderPeripheral(this);

    private boolean writeMode = false;
    private String pendingWriteData = "";
    @Nullable
    private String pendingLabel = null;
    private boolean pendingReadOnly = false;

    public NfcReaderBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlockTiles.NFC_READER, pos, blockState);
    }

    public NfcReaderPeripheral peripheral() {
        return peripheral;
    }

    public void flagWrite(String data, @Nullable String label, Boolean flagReadOnly) {
        var maxDataSize = ClassicPeripherals.CONFIG.nfcMaxDataSize;

        writeMode = true;
        pendingWriteData = data.substring(0, Math.min(data.length(), maxDataSize));
        pendingLabel = label;
        pendingReadOnly = flagReadOnly;

        field_11863.method_8501(method_11016(), method_11010().method_11657(NfcReaderBlock.STATE, NfcReaderBlock.NfcReaderState.WRITING));
    }

    public void cancelWrite() {
        writeMode = false;
        pendingWriteData = "";
        pendingLabel = null;
        pendingReadOnly = false;

        field_11863.method_8501(method_11016(), method_11010().method_11657(NfcReaderBlock.STATE, NfcReaderBlock.NfcReaderState.NONE));
    }

    public boolean isWriteMode() {
        return writeMode;
    }

    public void pingRead() {
        this.method_10997().method_8501(method_11016(), method_11010().method_11657(NfcReaderBlock.STATE, NfcReaderBlock.NfcReaderState.READING));
        field_11863.method_39279(method_11016(), ModBlocks.NFC_READER, 10);
    }

    public void onUse(class_1799 stack) {
        if (writeMode) {
            var tag = stack.method_7948();
            var readOnly = tag.method_10577("readOnly");
            if (readOnly) {
                peripheral.writeFeedback(false, "read_only");
                cancelWrite();
                return;
            }

            if (pendingLabel != null) {
                stack.method_7977(class_2561.method_43470(pendingLabel));
            } else {
                stack.method_7925();
            }

            // setting/clearing name overwrites the tag precedently created.
            tag = stack.method_7948();
            tag.method_10582("data", pendingWriteData);
            tag.method_10556("readOnly", pendingReadOnly);

            peripheral.writeFeedback(true, "success");
            cancelWrite();
        } else {
            var data = NfcCardItem.getData(stack);
            if (data.isPresent()) {
                peripheral.read(data.get());
                pingRead();
            }
        }
    }
}
