/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.core.Location;
import me.alexdevs.classicPeripherals.tiles.AbstractRadioBlockEntity;
import net.minecraft.class_1937;

public class TowerNetwork {
    private static final Map<Location, AbstractRadioBlockEntity> towers = new HashMap<Location, AbstractRadioBlockEntity>();
    public static final int MIN_FREQUENCY = 0;
    public static final int MAX_FREQUENCY = 65535;
    public static final int STEP_FREQUENCY = 1;

    public static int getChannel(int frequency) {
        return (frequency - 0) / 1;
    }

    public static int getFrequency(int channel) {
        return channel * 1 + 0;
    }

    public static void addTower(AbstractRadioBlockEntity tower) {
        Location location = new Location(tower.method_11016(), tower.method_10997());
        towers.put(location, tower);
    }

    public static void removeTower(AbstractRadioBlockEntity tower) {
        Location location = new Location(tower.method_11016(), tower.method_10997());
        towers.remove(location);
    }

    public static void broadcast(AbstractRadioBlockEntity sourceTower, String data) {
        if (!sourceTower.canBroadcast()) {
            throw new IllegalStateException(String.valueOf((Object)sourceTower) + " cannot broadcast.");
        }
        class_1937 level = sourceTower.method_10997();
        int channel = sourceTower.getChannel();
        data = data.substring(0, Math.min(data.length(), ClassicPeripherals.CONFIG.radioTowerMaxMessageSize));
        List<AbstractRadioBlockEntity> receivers = towers.values().stream().filter(x -> x.method_10997() == level && x.getChannel() == channel && x != sourceTower).toList();
        for (AbstractRadioBlockEntity receiver : receivers) {
            if (!receiver.inRange(sourceTower)) continue;
            double distance = receiver.getAntennaVec().method_1025(sourceTower.getAntennaVec());
            receiver.receive(data, Math.sqrt(distance), sourceTower);
        }
    }
}

