/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.peripherals;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.AttachedComputerSet;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.NoSuchElementException;
import me.alexdevs.classicPeripherals.core.TowerNetwork;
import me.alexdevs.classicPeripherals.tiles.AbstractRadioBlockEntity;
import org.jspecify.annotations.Nullable;
import oshi.annotation.concurrent.GuardedBy;

public class RadioPeripheral
implements IPeripheral {
    private final AbstractRadioBlockEntity radioTower;
    @GuardedBy(value="computers")
    private final AttachedComputerSet computers = new AttachedComputerSet();

    public RadioPeripheral(AbstractRadioBlockEntity radioTower) {
        this.radioTower = radioTower;
    }

    public String getType() {
        return "radio_tower";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable IPeripheral other) {
        if (!(other instanceof RadioPeripheral)) return false;
        RadioPeripheral o = (RadioPeripheral)other;
        if (this.radioTower != o.radioTower) return false;
        return true;
    }

    public void attach(IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(String data, double distance) {
        AttachedComputerSet attachedComputerSet = this.computers;
        synchronized (attachedComputerSet) {
            this.computers.forEach(computer -> computer.queueEvent("radio_message", new Object[]{computer.getAttachmentName(), data, distance}));
        }
    }

    @LuaFunction
    public final boolean isValid() {
        return this.radioTower.isValid();
    }

    @LuaFunction
    public final void broadcast(String data) throws LuaException {
        if (!this.radioTower.isValid()) {
            throw new LuaException("The radio tower is not built correctly.");
        }
        if (!this.radioTower.canBroadcast()) {
            throw new LuaException("This antenna is not capable of broadcasting.");
        }
        TowerNetwork.broadcast(this.radioTower, data);
        try {
            this.radioTower.ping();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @LuaFunction
    public final boolean canBroadcast() {
        return this.radioTower.canBroadcast();
    }

    @LuaFunction(mainThread=true)
    public final void setFrequency(ILuaContext context, int frequency) throws LuaException {
        if (frequency < 0 || frequency > 65535) {
            throw new LuaException("Frequency out of range. Must be between 0 and 65535.");
        }
        if (!this.radioTower.isValid()) {
            throw new LuaException("The radio tower is not built correctly.");
        }
        int channel = TowerNetwork.getChannel(frequency);
        this.radioTower.setChannel(channel);
    }

    @LuaFunction
    public final int getFrequency() throws LuaException {
        if (!this.radioTower.isValid()) {
            throw new LuaException("The radio tower is not built correctly.");
        }
        int channel = this.radioTower.getChannel();
        return TowerNetwork.getFrequency(channel);
    }

    @LuaFunction
    public final int getHeight() throws LuaException {
        if (!this.radioTower.isValid()) {
            throw new LuaException("The radio tower is not built correctly.");
        }
        return this.radioTower.getHeight();
    }
}

