/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.tiles;

import dan200.computercraft.api.peripheral.IPeripheral;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.core.TowerNetwork;
import me.alexdevs.classicPeripherals.peripherals.RadioPeripheral;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_7225;

public abstract class AbstractRadioBlockEntity
extends class_2586 {
    protected final Random random = new Random();
    protected int towerHeight = 1;
    protected boolean isValid = true;
    protected final RadioPeripheral peripheral = new RadioPeripheral(this);
    protected boolean initialized = false;
    protected int pingTicks = 4;
    protected long lastPing = 0L;

    public AbstractRadioBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 state) {
        super(blockEntityType, pos, state);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registries) {
        super.method_11014(nbt, registries);
        if (nbt.method_10545("radio_channel")) {
            this.peripheral.setChannel(nbt.method_10550("radio_channel"));
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registries) {
        super.method_11007(nbt, registries);
        nbt.method_10569("radio_channel", this.peripheral.getChannel());
    }

    public void method_11012() {
        super.method_11012();
        this.invalidate();
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, AbstractRadioBlockEntity be) {
        if (!be.initialized) {
            be.initialized = true;
            be.validate();
        } else if (be.isValid) {
            long time = level.method_8510();
            long delta = time - be.lastPing;
            if (delta == 0L) {
                be.onPing();
            } else if (delta >= (long)be.pingTicks) {
                be.afterPing();
            }
        }
    }

    public static double getSafeRange(double maxRange) {
        return maxRange - maxRange * ClassicPeripherals.CONFIG.radioTowerLossFactor;
    }

    public boolean canBroadcast() {
        return this.isValid;
    }

    public void validate() {
        this.isValid = true;
        TowerNetwork.addReceiver(this.peripheral);
    }

    public void invalidate() {
        this.isValid = false;
        TowerNetwork.removeReceiver(this.peripheral);
    }

    public void ping() {
        if (this.field_11863 != null) {
            this.lastPing = this.field_11863.method_8510();
        }
    }

    protected abstract void onPing();

    protected abstract void afterPing();

    public abstract class_2338 getAntennaPos();

    public int getHeight() {
        return this.towerHeight;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public IPeripheral peripheral() {
        return this.peripheral;
    }

    public int getMaximumRange() {
        if (!this.isValid) {
            return 0;
        }
        return this.towerHeight * ClassicPeripherals.CONFIG.radioTowerSegmentRange;
    }

    public int getEffectiveMaxRange() {
        int y = this.getAntennaPos().method_10264();
        int range = this.getMaximumRange();
        if (y >= 96) {
            return range;
        }
        return Math.max(8, (int)(96.0 * (1.0 - Math.pow(Math.E, -0.05 * (double)y)) / 100.0 * (double)range));
    }

    public boolean inRange(AbstractRadioBlockEntity other) {
        int range = Math.max(this.getMaximumRange(), other.getMaximumRange());
        double distance = this.getAntennaPos().method_33096(255).method_10262((class_2382)other.getAntennaPos().method_33096(255));
        return distance <= (double)(range * range);
    }

    public String flipString(String data, double percentage) {
        byte[] bytes = data.getBytes(StandardCharsets.US_ASCII);
        int total = bytes.length * 8;
        int toFlip = (int)Math.ceil((double)total * percentage);
        for (int i = 0; i < toFlip; ++i) {
            int bit = this.random.nextInt(total);
            int byteIndex = bit / 8;
            int bitIndex = bit % 8;
            int n = byteIndex;
            bytes[n] = (byte)(bytes[n] ^ (byte)(1 << bitIndex));
        }
        return new String(bytes, StandardCharsets.US_ASCII);
    }
}

