package me.alexdevs.classicPeripherals.tiles;

import dan200.computercraft.api.peripheral.IPeripheral;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.core.TowerNetwork;
import me.alexdevs.classicPeripherals.peripherals.RadioPeripheral;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import java.nio.charset.StandardCharsets;
import java.util.Random;

public abstract class AbstractRadioBlockEntity extends class_2586 {
    protected final Random random = new Random();

    protected int towerHeight = 1;
    protected boolean isValid = true;
    protected final RadioPeripheral peripheral = new RadioPeripheral(this);
    protected boolean initialized = false;
    protected int pingTicks = 4;
    protected long lastPing = 0;

    public AbstractRadioBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 state) {
        super(blockEntityType, pos, state);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);

        if (nbt.method_10545("radio_channel")) {
            peripheral.setChannel(nbt.method_10550("radio_channel"));
        }
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);

        nbt.method_10569("radio_channel", peripheral.getChannel());
    }

    @Override
    public void method_11012() {
        super.method_11012();
        invalidate();
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, AbstractRadioBlockEntity be) {
        if (!be.initialized) {
            be.initialized = true;
            be.validate();
        } else if (be.isValid) {
            // Skip the first ever tick
            var time = level.method_8510();

            var delta = time - be.lastPing;
            if (delta == 0) {
                be.onPing();
            } else if (delta >= be.pingTicks) {
                be.afterPing();
            }
        }
    }

    public static double getSafeRange(double maxRange) {
        return maxRange - (maxRange * ClassicPeripherals.CONFIG.radioTowerLossFactor);
    }

    public boolean canBroadcast() {
        return isValid;
    }

    public void validate() {
        isValid = true;
        TowerNetwork.addReceiver(peripheral);
    }

    public void invalidate() {
        isValid = false;
        TowerNetwork.removeReceiver(peripheral);
    }

    public void ping() {
        if (field_11863 != null) {
            lastPing = field_11863.method_8510();
        }
    }

    protected abstract void onPing();

    protected abstract void afterPing();

    public abstract class_2338 getAntennaPos();

    public int getHeight() {
        return towerHeight;
    }

    public boolean isValid() {
        return isValid;
    }


    public IPeripheral peripheral() {
        return peripheral;
    }

    public int getMaximumRange() {
        if (!isValid)
            return 0;

        return towerHeight * ClassicPeripherals.CONFIG.radioTowerSegmentRange;
    }

    public int getEffectiveMaxRange() {
        var y = this.getAntennaPos().method_10264();

        var range = getMaximumRange();

        if (y >= 96) {
            return range;
        }

        return Math.max(8, (int) (96 * (1 - Math.pow(Math.E, -0.05 * y)) / 100d * range));
    }

    public boolean inRange(AbstractRadioBlockEntity other) {
        var range = Math.max(this.getMaximumRange(), other.getMaximumRange());
        var distance = getAntennaPos().method_33096(255).method_10262(other.getAntennaPos().method_33096(255));
        return distance <= range * range;
    }

    public String flipString(String data, double percentage) {
        var bytes = data.getBytes(StandardCharsets.US_ASCII);
        var total = bytes.length * 8;
        var toFlip = (int) Math.ceil(total * percentage);

        for (int i = 0; i < toFlip; i++) {
            var bit = random.nextInt(total);
            var byteIndex = bit / 8;
            var bitIndex = bit % 8;
            bytes[byteIndex] ^= (byte) (1 << bitIndex);
        }
        return new String(bytes, StandardCharsets.US_ASCII);
    }
}
