/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.tiles;

import me.alexdevs.classicPeripherals.block.ModBlocks;
import me.alexdevs.classicPeripherals.block.tower.TowerHeadBlock;
import me.alexdevs.classicPeripherals.tiles.AbstractRadioBlockEntity;
import me.alexdevs.classicPeripherals.tiles.ModBlockTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TowerBlockEntity
extends AbstractRadioBlockEntity {
    public TowerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockTiles.TOWER_BASE.get(), pos, state);
    }

    @Override
    public void validate() {
        this.towerHeight = 1;
        this.isValid = false;
        BlockPos pos = this.getBlockPos();
        for (int i = 1; i < 24 && this.level.getBlockState(pos = pos.above(1)).is(ModBlocks.TOWER_SEGMENT); ++i) {
            ++this.towerHeight;
        }
        if (!this.level.getBlockState(pos).is(ModBlocks.TOWER_HEAD)) {
            this.invalidate();
            return;
        }
        ++this.towerHeight;
        if (this.towerHeight < 2) {
            this.invalidate();
            return;
        }
        this.topPos = pos.immutable();
        super.validate();
    }

    @Override
    public void ping() {
        BlockState head = this.level.getBlockState(this.getTopPos());
        this.level.setBlockAndUpdate(this.getTopPos(), (BlockState)head.setValue((Property)TowerHeadBlock.ACTIVE, (Comparable)Boolean.valueOf(true)));
        this.level.scheduleTick(this.getTopPos(), (Block)ModBlocks.TOWER_HEAD.get(), 4);
    }
}

