package me.alexdevs.classicPeripherals.client;

import me.alexdevs.classicPeripherals.ModComponents;
import me.alexdevs.classicPeripherals.block.ModBlocks;
import me.alexdevs.classicPeripherals.item.ModItems;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1921;

public class ClassicPeripheralsClient implements ClientModInitializer {

    @Override
    public void onInitializeClient() {
        BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23581(), ModBlocks.TOWER_BASE, ModBlocks.TOWER_SEGMENT, ModBlocks.TOWER_HEAD, ModBlocks.ANTENNA);

        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            if (tintIndex == 0) {
                var components = stack.method_57353();
                if (components.method_57832(ModComponents.NFC_COLOR)) {
                    return 0xFF_000000 | components.method_57830(ModComponents.NFC_COLOR, 0xFFFFFF);
                }
            }

            return 0xFF_FFFFFF;
        }, ModItems.NFC_CARD);

        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            if (tintIndex == 0) {
                var components = stack.method_57353();
                if (components.method_57832(ModComponents.NFC_COLOR)) {
                    return 0xFF_000000 | components.method_57830(ModComponents.NFC_COLOR, 0xFFFFFF);
                }
            }

            return 0xFF_FFFFFF;
        }, ModItems.RFID_BADGE);
    }
}
