/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.block;

import com.mojang.serialization.MapCodec;
import me.alexdevs.classicPeripherals.item.ModItems;
import me.alexdevs.classicPeripherals.tiles.NfcReaderBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NfcReaderBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final EnumProperty<NfcReaderState> STATE = EnumProperty.create((String)"state", NfcReaderState.class);

    public NfcReaderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue(STATE, (Comparable)((Object)NfcReaderState.NONE)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return NfcReaderBlock.simpleCodec(NfcReaderBlock::new);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HorizontalDirectionalBlock.FACING}).add(new Property[]{STATE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(STATE, (Comparable)((Object)NfcReaderState.NONE));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity be;
        if (stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if ((stack.is(ModItems.NFC_CARD) || stack.is(ModItems.RFID_BADGE)) && (be = level.getBlockEntity(pos)) instanceof NfcReaderBlockEntity) {
            NfcReaderBlockEntity reader = (NfcReaderBlockEntity)be;
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            reader.onUse(stack);
            return ItemInteractionResult.CONSUME;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new NfcReaderBlockEntity(pos, state);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.setBlockAndUpdate(pos, (BlockState)state.setValue(STATE, (Comparable)((Object)NfcReaderState.NONE)));
    }

    public static enum NfcReaderState implements StringRepresentable
    {
        NONE("none"),
        READING("reading"),
        WRITING("writing");

        public final String name;

        private NfcReaderState(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

