/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.block.tower;

import me.alexdevs.classicPeripherals.block.ModBlocks;
import me.alexdevs.classicPeripherals.tiles.TowerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class TowerSegmentBlock
extends Block {
    public TowerSegmentBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    private void triggerBase(Level level, BlockPos blockPos) {
        for (int i = 1; i < 32; ++i) {
            BlockPos below = blockPos.below(i);
            BlockState blockBelow = level.getBlockState(below);
            if (!blockBelow.is(ModBlocks.TOWER_BASE)) continue;
            BlockEntity be = level.getBlockEntity(below);
            if (!(be instanceof TowerBlockEntity)) break;
            TowerBlockEntity base = (TowerBlockEntity)be;
            base.validate();
            break;
        }
    }

    public void onPlace(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        super.onPlace(blockState, level, blockPos, blockState2, bl);
        this.triggerBase(level, blockPos);
    }

    public void onRemove(BlockState state, Level level, BlockPos blockPos, BlockState newState, boolean moved) {
        super.onRemove(state, level, blockPos, newState, moved);
        this.triggerBase(level, blockPos);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)1.0, (double)0.75);
    }
}

