package me.alexdevs.classicPeripherals.block;

import com.mojang.serialization.MapCodec;
import me.alexdevs.classicPeripherals.item.NfcCardItem;
import me.alexdevs.classicPeripherals.item.ModItems;
import me.alexdevs.classicPeripherals.tiles.NfcReaderBlockEntity;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import net.minecraft.class_9062;
import net.minecraft.world.level.block.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NfcReaderBlock extends class_2383 implements class_2343 {
    public enum NfcReaderState implements class_3542 {
        NONE("none"),
        READING("reading"),
        WRITING("writing"),
        ;

        public final String name;

        NfcReaderState(String name) {
            this.name = name;
        }

        @Override
        public @NotNull String method_15434() {
            return name;
        }
    }

    public static final class_2754<NfcReaderState> STATE = class_2754.method_11850("state", NfcReaderState.class);

    public NfcReaderBlock(class_2251 properties) {
        super(properties);

        method_9590(method_9564()
                .method_11657(class_2383.field_11177, class_2350.field_11043)
                .method_11657(STATE, NfcReaderState.NONE)
        );
    }

    @Override
    protected MapCodec<? extends class_2383> method_53969() {
        return method_54094(NfcReaderBlock::new);
    }

    @Override
    public @NotNull class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder
                .method_11667(class_2383.field_11177)
                .method_11667(STATE);
    }

    @Override
    public @Nullable class_2680 method_9605(class_1750 context) {
        return super.method_9605(context)
                .method_11657(field_11177, context.method_8042().method_10153())
                .method_11657(STATE, NfcReaderState.NONE);
    }

    @Override
    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        if(stack.method_7960()) {
            return class_9062.field_47731;
        }

        if(stack.method_31574(ModItems.NFC_CARD) || stack.method_31574(ModItems.RFID_BADGE)) {
            var be = level.method_8321(pos);
            if(be instanceof NfcReaderBlockEntity reader) {

                if(level.field_9236) {
                    return class_9062.field_47728;
                }

                reader.onUse(stack);
                return class_9062.field_47729;
            }
        }

        return super.method_55765(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new NfcReaderBlockEntity(pos, state);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        level.method_8501(pos, state.method_11657(STATE, NfcReaderState.NONE));
    }
}
