package me.alexdevs.classicPeripherals.upgrades.radio;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.peripherals.AbstractRadioPeripheral;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import org.jspecify.annotations.Nullable;

public class TurtleRadio implements ITurtleUpgrade {
    public static class RadioTurtlePeripheral extends AbstractRadioPeripheral {
        private final ITurtleAccess turtle;

        public RadioTurtlePeripheral(ITurtleAccess turtle) {
            this.turtle = turtle;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public class_1937 getLevel() {
            return turtle.getLevel();
        }

        @Override
        public class_243 getPosition() {
            return class_243.method_24954(turtle.getPosition());
        }

        @Override
        public double getRange() {
            return 0;
        }

        @Override
        public void ping() {

        }

        @Override
        public boolean canBroadcast() {
            return ClassicPeripherals.CONFIG.antennaCanBroadcast;
        }

        @Override
        public boolean equals(@Nullable IPeripheral other) {
            return this == other || (other instanceof TurtleRadio.RadioTurtlePeripheral o && turtle == o.turtle);
        }
    }

    private final class_2960 id;
    private final class_1799 stack;

    public TurtleRadio(class_2960 id, class_1799 stack) {
        this.id = id;
        this.stack = stack;
    }

    @Override
    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.PERIPHERAL;
    }

    @Override
    public @Nullable IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new RadioTurtlePeripheral(turtle);
    }

    @Override
    public class_2960 getUpgradeID() {
        return id;
    }

    @Override
    public String getUnlocalisedAdjective() {
        return "upgrade.radio.adjective";
    }

    @Override
    public class_1799 getCraftingItem() {
        return stack;
    }
}
