package me.alexdevs.classicPeripherals.upgrades;


import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.pocket.PocketUpgradeSerialiser;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.upgrades.radio.PocketRadio;
import me.alexdevs.classicPeripherals.upgrades.radio.TurtleRadio;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ModUpgrades {
    public static final PocketUpgradeSerialiser<PocketRadio> POCKET_RADIO =
            pocket("radio", PocketUpgradeSerialiser.simpleWithCustomItem(PocketRadio::new));

    public static final TurtleUpgradeSerialiser<TurtleRadio> TURTLE_RADIO =
            turtle("radio", TurtleUpgradeSerialiser.simpleWithCustomItem(TurtleRadio::new));

    @SuppressWarnings("unchecked")
    public static <T extends IPocketUpgrade> PocketUpgradeSerialiser<T> pocket(String name, PocketUpgradeSerialiser<T> upgrade) {
        var id = new class_2960(ClassicPeripherals.MOD_ID, name);
        var registry = (class_2378<? super PocketUpgradeSerialiser<?>>) class_7923.field_41167.method_10223(PocketUpgradeSerialiser.registryId().method_29177());
        if(registry == null) {
            throw new IllegalStateException("ComputerCraft has not yet initialized!");
        }

        return class_2378.method_10230(registry, id, upgrade);
    }

    @SuppressWarnings("unchecked")
    public static <T extends ITurtleUpgrade> TurtleUpgradeSerialiser<T> turtle(String name, TurtleUpgradeSerialiser<T> upgrade) {
        var id = new class_2960(ClassicPeripherals.MOD_ID, name);
        var registry = (class_2378<? super TurtleUpgradeSerialiser<?>>) class_7923.field_41167.method_10223(TurtleUpgradeSerialiser.registryId().method_29177());
        if(registry == null) {
            throw new IllegalStateException("ComputerCraft has not yet initialized!");
        }

        return class_2378.method_10230(registry, id, upgrade);
    }

    public static void initialize() {
    }
}
