/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.tiles;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.block.ModBlocks;
import me.alexdevs.classicPeripherals.block.RfidScannerBlock;
import me.alexdevs.classicPeripherals.item.ModItems;
import me.alexdevs.classicPeripherals.item.NfcCardItem;
import me.alexdevs.classicPeripherals.peripherals.RfidScannerPeripheral;
import me.alexdevs.classicPeripherals.tiles.ModBlockTiles;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class RfidScannerBlockEntity
extends class_2586 {
    protected final RfidScannerPeripheral peripheral = new RfidScannerPeripheral(this);

    public RfidScannerBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlockTiles.RFID_SCANNER, pos, blockState);
    }

    @Nullable
    public RfidScannerPeripheral peripheral(@Nullable class_2350 direction) {
        return direction == null || this.getDirection() == direction ? this.peripheral : null;
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)class_2318.field_10927);
    }

    public void scheduleScan() {
        this.method_10997().method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)RfidScannerBlock.ACTIVE, (Comparable)Boolean.valueOf(true)));
        this.field_11863.method_39279(this.method_11016(), (class_2248)ModBlocks.RFID_SCANNER, 2);
    }

    public void scan() {
        List<ScannedRfidBadge> badges = this.scanBadges();
        this.peripheral.emitScanEvent(badges);
    }

    private List<ScannedRfidBadge> scanBadges() {
        ArrayList<ScannedRfidBadge> badges = new ArrayList<ScannedRfidBadge>();
        class_1937 level = this.method_10997();
        class_243 origin = this.peripheral.getPosition();
        if (level.field_9236) {
            return List.of();
        }
        int range = ClassicPeripherals.CONFIG.rfidScanRange;
        List<class_3222> nearbyPlayers = level.method_18456().stream().filter(player -> player.method_19538().method_1025(origin) <= (double)(range * range)).map(player -> (class_3222)player).toList();
        for (class_3222 player2 : nearbyPlayers) {
            class_1661 inventory = player2.method_31548();
            for (class_1799 stack : inventory.field_7547) {
                Optional<String> data;
                if (!stack.method_31574(ModItems.RFID_BADGE) || (data = NfcCardItem.getData(stack)).isEmpty()) continue;
                badges.add(new ScannedRfidBadge(data.get(), player2.method_19538().method_1022(origin)));
            }
        }
        return badges;
    }

    public record ScannedRfidBadge(String data, double distance) {
    }
}

