/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.core;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.peripherals.AbstractRadioPeripheral;

public class TowerNetwork {
    private static final Set<AbstractRadioPeripheral> receivers = Collections.newSetFromMap(new ConcurrentHashMap());
    public static final int MIN_FREQUENCY = 0;
    public static final int MAX_FREQUENCY = 65535;
    public static final int STEP_FREQUENCY = 1;

    public static int getChannel(int frequency) {
        return (frequency - 0) / 1;
    }

    public static int getFrequency(int channel) {
        return channel * 1 + 0;
    }

    public static void addReceiver(AbstractRadioPeripheral receiver) {
        Objects.requireNonNull(receiver);
        receivers.add(receiver);
    }

    public static void removeReceiver(AbstractRadioPeripheral receiver) {
        Objects.requireNonNull(receiver);
        receivers.remove(receiver);
    }

    public static void broadcast(AbstractRadioPeripheral source, String data, double range) {
        if (!source.canBroadcast()) {
            return;
        }
        data = data.substring(0, Math.min(data.length(), ClassicPeripherals.CONFIG.radioTowerMaxMessageSize));
        for (AbstractRadioPeripheral receiver : receivers) {
            TowerNetwork.tryBroadcast(source, receiver, data, range);
        }
    }

    private static void tryBroadcast(AbstractRadioPeripheral sender, AbstractRadioPeripheral receiver, String data, double range) {
        if (sender == receiver) {
            return;
        }
        if (sender.getLevel() != receiver.getLevel()) {
            return;
        }
        if (sender.getChannel() != receiver.getChannel()) {
            return;
        }
        double receiveRange = Math.max(range, receiver.getRange());
        double distanceSquared = receiver.getPosition().m_82557_(sender.getPosition());
        if (distanceSquared <= receiveRange * receiveRange) {
            receiver.receive(data, Math.sqrt(distanceSquared), receiveRange);
        }
    }
}

