/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.item;

import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class NfcCardItem
extends Item {
    public NfcCardItem(Item.Properties properties) {
        super(properties);
    }

    public static Optional<String> getData(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        String data = tag.m_128461_("data");
        if (data.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(data);
    }

    @NotNull
    public InteractionResult m_6880_(ItemStack stack, Player source, LivingEntity target, InteractionHand usedHand) {
        if (source.m_9236_().m_5776_()) {
            if (target instanceof Player) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        Optional<String> data = NfcCardItem.getData(stack);
        if (data.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (!(target instanceof ServerPlayer)) {
            return InteractionResult.PASS;
        }
        ServerPlayer player = (ServerPlayer)target;
        Inventory inv = player.m_150109_();
        if (inv.m_204075_(ComputerCraftTags.Items.POCKET_COMPUTERS)) {
            List<ServerComputer> computers = NfcCardItem.getAllPocketComputers(player);
            computers.forEach(computer -> computer.queueEvent("nfc_data", new Object[]{"internal", data.get()}));
        }
        return InteractionResult.CONSUME;
    }

    private static List<ServerComputer> getAllPocketComputers(ServerPlayer player) {
        ArrayList<ServerComputer> list = new ArrayList<ServerComputer>();
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack item = inventory.m_8020_(i);
            if (!item.m_204131_().anyMatch(x -> x == ComputerCraftTags.Items.POCKET_COMPUTERS)) continue;
            PocketServerComputer computer = PocketComputerItem.getServerComputer((MinecraftServer)player.m_20194_(), (ItemStack)item);
            list.add((ServerComputer)computer);
        }
        return list;
    }
}

