/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.peripherals;

import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.function.Function;
import javax.annotation.Nullable;
import me.alexdevs.classicPeripherals.peripherals.NfcReaderPeripheral;
import me.alexdevs.classicPeripherals.peripherals.RfidScannerPeripheral;
import me.alexdevs.classicPeripherals.tiles.AbstractRadioBlockEntity;
import me.alexdevs.classicPeripherals.tiles.AntennaBlockEntity;
import me.alexdevs.classicPeripherals.tiles.NfcReaderBlockEntity;
import me.alexdevs.classicPeripherals.tiles.RfidScannerBlockEntity;
import me.alexdevs.classicPeripherals.tiles.TowerBlockEntity;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;

public class Peripherals {
    public static final Capability<IPeripheral> CAPABILITY_PERIPHERAL = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPeripheral>(){});
    private static final ResourceLocation PERIPHERAL = new ResourceLocation("classicperipherals", "peripheral");

    public static void register(AttachCapabilitiesEvent<BlockEntity> event) {
        Object object = event.getObject();
        if (object instanceof TowerBlockEntity) {
            TowerBlockEntity tower = (TowerBlockEntity)((Object)object);
            PeripheralProvider.attach(event, tower, AbstractRadioBlockEntity.RadioPeripheral::new);
        }
        if ((object = event.getObject()) instanceof AntennaBlockEntity) {
            AntennaBlockEntity antenna = (AntennaBlockEntity)((Object)object);
            PeripheralProvider.attach(event, antenna, AbstractRadioBlockEntity.RadioPeripheral::new);
        }
        if ((object = event.getObject()) instanceof NfcReaderBlockEntity) {
            NfcReaderBlockEntity reader = (NfcReaderBlockEntity)((Object)object);
            PeripheralProvider.attach(event, reader, NfcReaderPeripheral::new);
        }
        if ((object = event.getObject()) instanceof RfidScannerBlockEntity) {
            RfidScannerBlockEntity scanner = (RfidScannerBlockEntity)((Object)object);
            PeripheralProvider.attach(event, scanner, RfidScannerPeripheral::new);
        }
    }

    private static final class PeripheralProvider<O extends BlockEntity>
    implements ICapabilityProvider {
        private final O blockEntity;
        private final Function<O, IPeripheral> factory;
        @Nullable
        private LazyOptional<IPeripheral> peripheral;

        private PeripheralProvider(O blockEntity, Function<O, IPeripheral> factory) {
            this.blockEntity = blockEntity;
            this.factory = factory;
        }

        private static <O extends BlockEntity> void attach(AttachCapabilitiesEvent<BlockEntity> event, O blockEntity, Function<O, IPeripheral> factory) {
            PeripheralProvider<O> provider = new PeripheralProvider<O>(blockEntity, factory);
            event.addCapability(PERIPHERAL, provider);
            event.addListener(provider::invalidate);
        }

        private void invalidate() {
            if (this.peripheral != null) {
                this.peripheral.invalidate();
            }
            this.peripheral = null;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction direction) {
            if (capability != CAPABILITY_PERIPHERAL) {
                return LazyOptional.empty();
            }
            if (this.blockEntity.m_58901_()) {
                return LazyOptional.empty();
            }
            LazyOptional peripheral = this.peripheral;
            return (peripheral == null ? (this.peripheral = LazyOptional.of(() -> this.factory.apply(this.blockEntity))) : peripheral).cast();
        }
    }
}

