/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.peripherals;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.lua.ObjectLuaTable;
import dan200.computercraft.api.peripheral.AttachedComputerSet;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.alexdevs.classicPeripherals.tiles.RfidScannerBlockEntity;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class RfidScannerPeripheral
implements IPeripheral {
    private final RfidScannerBlockEntity rfidScanner;
    private final AttachedComputerSet computers = new AttachedComputerSet();

    public RfidScannerPeripheral(RfidScannerBlockEntity rfidScanner) {
        this.rfidScanner = rfidScanner;
    }

    public String getType() {
        return "rfid_scanner";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable IPeripheral other) {
        if (!(other instanceof RfidScannerPeripheral)) return false;
        RfidScannerPeripheral o = (RfidScannerPeripheral)other;
        if (this.rfidScanner != o.rfidScanner) return false;
        return true;
    }

    public void attach(IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public Vec3 getPosition() {
        return Vec3.m_82528_((Vec3i)this.rfidScanner.m_58899_().m_121945_(this.rfidScanner.getDirection()));
    }

    public void emitScanEvent(List<RfidScannerBlockEntity.ScannedRfidBadge> badges) {
        HashMap<Integer, ObjectLuaTable> map = new HashMap<Integer, ObjectLuaTable>();
        for (int i = 1; i <= badges.size(); ++i) {
            RfidScannerBlockEntity.ScannedRfidBadge badge = badges.get(i - 1);
            map.put(i, new ObjectLuaTable(Map.of("data", badge.data(), "distance", badge.distance())));
        }
        ObjectLuaTable table = new ObjectLuaTable(map);
        this.computers.forEach(computer -> computer.queueEvent("rfid_scan", new Object[]{computer.getAttachmentName(), table}));
    }

    @LuaFunction
    public final MethodResult scan() {
        this.rfidScanner.scheduleScan();
        return MethodResult.pullEvent((String)"rfid_scan", args -> {
            if (args.length != 3) {
                return null;
            }
            return MethodResult.of((Object)args[2]);
        });
    }
}

