/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.recipe;

import dan200.computercraft.shared.util.ColourTracker;
import me.alexdevs.classicPeripherals.item.ModItems;
import me.alexdevs.classicPeripherals.recipe.ModRecipes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RfidBadgeRecipe
extends CustomRecipe {
    public RfidBadgeRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        boolean hasItem = false;
        ColourTracker tracker = new ColourTracker();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_((Item)ModItems.RFID_BADGE.get())) {
                hasItem = true;
                continue;
            }
            Item item = stack.m_41720_();
            if (!(item instanceof DyeItem)) continue;
            DyeItem dye = (DyeItem)item;
            tracker.addColour(dye.m_41089_());
        }
        return hasItem && tracker.hasColour();
    }

    @NotNull
    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack item = null;
        ColourTracker tracker = new ColourTracker();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_((Item)ModItems.RFID_BADGE.get())) {
                CompoundTag tag;
                item = stack.m_41777_();
                item.m_41764_(1);
                if (!item.m_41782_() || !(tag = item.m_41784_()).m_128441_("color")) continue;
                int value = tag.m_128451_("color");
                int r = value >> 16 & 0xFF;
                int g = value >> 8 & 0xFF;
                int b = value & 0xFF;
                tracker.addColour(r, g, b);
                continue;
            }
            Item item2 = stack.m_41720_();
            if (!(item2 instanceof DyeItem)) continue;
            DyeItem dye = (DyeItem)item2;
            tracker.addColour(dye.m_41089_());
        }
        if (item != null && tracker.hasColour()) {
            item.m_41784_().m_128405_("color", tracker.getColour());
            return item;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.RFID_BADGE_RECIPE.get();
    }
}

