/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.tiles;

import dan200.computercraft.api.peripheral.IPeripheral;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.core.TowerNetwork;
import me.alexdevs.classicPeripherals.peripherals.AbstractRadioPeripheral;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public abstract class AbstractRadioBlockEntity
extends BlockEntity {
    protected int towerHeight = 1;
    protected boolean isValid = true;
    protected final RadioPeripheral peripheral = new RadioPeripheral(this);
    protected boolean initialized = false;
    protected int pingTicks = 4;
    protected long lastPing = 0L;

    public AbstractRadioBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("radio_channel")) {
            this.peripheral.setChannel(nbt.m_128451_("radio_channel"));
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("radio_channel", this.peripheral.getChannel());
    }

    public void m_7651_() {
        super.m_7651_();
        this.invalidate();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractRadioBlockEntity be) {
        if (!be.initialized) {
            be.initialized = true;
            be.validate();
        } else if (be.isValid) {
            long time = level.m_46467_();
            long delta = time - be.lastPing;
            if (delta == 0L) {
                be.onPing();
            } else if (delta >= (long)be.pingTicks) {
                be.afterPing();
            }
        }
    }

    public static double getSafeRange(double maxRange) {
        return maxRange - maxRange * ClassicPeripherals.CONFIG.radioTowerLossFactor;
    }

    public boolean canBroadcast() {
        return this.isValid;
    }

    public void validate() {
        this.isValid = true;
        TowerNetwork.addReceiver(this.peripheral);
    }

    public void invalidate() {
        this.isValid = false;
        TowerNetwork.removeReceiver(this.peripheral);
    }

    public void ping() {
        if (this.f_58857_ != null) {
            this.lastPing = this.f_58857_.m_46467_();
        }
    }

    protected abstract void onPing();

    protected abstract void afterPing();

    public abstract BlockPos getAntennaPos();

    public int getHeight() {
        return this.towerHeight;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public IPeripheral peripheral() {
        return this.peripheral;
    }

    public int getMaximumRange() {
        if (!this.isValid) {
            return 0;
        }
        return this.towerHeight * ClassicPeripherals.CONFIG.radioTowerSegmentRange;
    }

    public int getEffectiveMaxRange() {
        int y = this.getAntennaPos().m_123342_();
        int range = this.getMaximumRange();
        if (y >= 96) {
            return range;
        }
        return Math.max(8, (int)(96.0 * (1.0 - Math.pow(Math.E, -0.05 * (double)y)) / 100.0 * (double)range));
    }

    public static class RadioPeripheral
    extends AbstractRadioPeripheral {
        private final AbstractRadioBlockEntity be;

        public RadioPeripheral(AbstractRadioBlockEntity be) {
            this.be = be;
        }

        @Override
        public boolean isValid() {
            return this.be.isValid();
        }

        @Override
        public Level getLevel() {
            return this.be.m_58904_();
        }

        @Override
        public Vec3 getPosition() {
            return Vec3.m_82528_((Vec3i)this.be.getAntennaPos());
        }

        @Override
        public double getRange() {
            return this.be.getEffectiveMaxRange();
        }

        @Override
        public void ping() {
            this.be.ping();
        }

        @Override
        public boolean canBroadcast() {
            return this.be.canBroadcast();
        }

        @Override
        public int getHeight() {
            return this.be.getHeight();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable IPeripheral other) {
            if (this == other) return true;
            if (!(other instanceof RadioPeripheral)) return false;
            RadioPeripheral o = (RadioPeripheral)other;
            if (this.be != o.be) return false;
            return true;
        }
    }
}

