/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.tiles;

import java.util.Optional;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.block.ModBlocks;
import me.alexdevs.classicPeripherals.block.NfcReaderBlock;
import me.alexdevs.classicPeripherals.item.NfcCardItem;
import me.alexdevs.classicPeripherals.peripherals.NfcReaderPeripheral;
import me.alexdevs.classicPeripherals.tiles.ModBlockTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;

public class NfcReaderBlockEntity
extends BlockEntity {
    protected final NfcReaderPeripheral peripheral = new NfcReaderPeripheral(this);
    private boolean writeMode = false;
    private String pendingWriteData = "";
    private @Nullable String pendingLabel = null;
    private boolean pendingReadOnly = false;

    public NfcReaderBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockTiles.NFC_READER.get(), pos, blockState);
    }

    public NfcReaderPeripheral peripheral() {
        return this.peripheral;
    }

    public void flagWrite(String data, @Nullable String label, Boolean flagReadOnly) {
        int maxDataSize = ClassicPeripherals.CONFIG.nfcMaxDataSize;
        this.writeMode = true;
        this.pendingWriteData = data.substring(0, Math.min(data.length(), maxDataSize));
        this.pendingLabel = label;
        this.pendingReadOnly = flagReadOnly;
        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(NfcReaderBlock.STATE, (Comparable)((Object)NfcReaderBlock.NfcReaderState.WRITING)));
    }

    public void cancelWrite() {
        this.writeMode = false;
        this.pendingWriteData = "";
        this.pendingLabel = null;
        this.pendingReadOnly = false;
        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(NfcReaderBlock.STATE, (Comparable)((Object)NfcReaderBlock.NfcReaderState.NONE)));
    }

    public boolean isWriteMode() {
        return this.writeMode;
    }

    public void pingRead() {
        this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(NfcReaderBlock.STATE, (Comparable)((Object)NfcReaderBlock.NfcReaderState.READING)));
        this.f_58857_.m_186460_(this.m_58899_(), (Block)ModBlocks.NFC_READER.get(), 10);
    }

    public void onUse(ItemStack stack) {
        if (this.writeMode) {
            CompoundTag tag = stack.m_41784_();
            boolean readOnly = tag.m_128471_("readOnly");
            if (readOnly) {
                this.peripheral.writeFeedback(false, "read_only");
                this.cancelWrite();
                return;
            }
            if (this.pendingLabel != null) {
                stack.m_41714_((Component)Component.m_237113_((String)this.pendingLabel));
            } else {
                stack.m_41787_();
            }
            tag = stack.m_41784_();
            tag.m_128359_("data", this.pendingWriteData);
            tag.m_128379_("readOnly", this.pendingReadOnly);
            this.peripheral.writeFeedback(true, "success");
            this.cancelWrite();
        } else {
            Optional<String> data = NfcCardItem.getData(stack);
            if (data.isPresent()) {
                this.peripheral.read(data.get());
                this.pingRead();
            }
        }
    }
}

