/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.classicPeripherals.upgrades.radio;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import me.alexdevs.classicPeripherals.ClassicPeripherals;
import me.alexdevs.classicPeripherals.peripherals.AbstractRadioPeripheral;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class PocketRadio
implements IPocketUpgrade {
    private final ResourceLocation id;
    private final ItemStack stack;

    public PocketRadio(ResourceLocation id, ItemStack stack) {
        this.id = id;
        this.stack = stack;
    }

    public @Nullable IPeripheral createPeripheral(IPocketAccess pocket) {
        return new RadioPocketPeripheral(pocket);
    }

    public ResourceLocation getUpgradeID() {
        return this.id;
    }

    public String getUnlocalisedAdjective() {
        return "upgrade.radio.adjective";
    }

    public ItemStack getCraftingItem() {
        return this.stack;
    }

    public static class RadioPocketPeripheral
    extends AbstractRadioPeripheral {
        private final IPocketAccess pocket;

        public RadioPocketPeripheral(IPocketAccess pocket) {
            this.pocket = pocket;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Level getLevel() {
            return this.pocket.getLevel();
        }

        @Override
        public Vec3 getPosition() {
            return this.pocket.getPosition();
        }

        @Override
        public double getRange() {
            return 0.0;
        }

        @Override
        public void ping() {
        }

        @Override
        public boolean canBroadcast() {
            return ClassicPeripherals.CONFIG.antennaCanBroadcast;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable IPeripheral other) {
            if (this == other) return true;
            if (!(other instanceof RadioPocketPeripheral)) return false;
            RadioPocketPeripheral o = (RadioPocketPeripheral)other;
            if (this.pocket != o.pocket) return false;
            return true;
        }
    }
}

